/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.model;

import com.jfinal.ext.kit.DateKit;
import io.jboot.db.model.Column;
import io.jboot.db.model.Columns;
import io.jboot.utils.CollectionUtil;
import io.jboot.utils.StrUtil;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;

class Util {
    static final Object[] NULL_PARA_ARRAY = new Object[0];

    Util() {
    }

    static Object[] getValueArray(List<Column> columns) {
        if (columns == null || columns.isEmpty()) {
            return NULL_PARA_ARRAY;
        }
        LinkedList<Object> paras = new LinkedList<Object>();
        for (Column column : columns) {
            Object value;
            if (!column.hasPara() || (value = column.getValue()) == null) continue;
            if (value.getClass().isArray()) {
                Object[] values;
                for (Object v : values = (Object[])value) {
                    if (v.getClass() == int[].class) {
                        Util.addAll(paras, (int[])v);
                        continue;
                    }
                    if (v.getClass() == long[].class) {
                        Util.addAll(paras, (long[])v);
                        continue;
                    }
                    if (v.getClass() == short[].class) {
                        Util.addAll(paras, (short[])v);
                        continue;
                    }
                    paras.add(v);
                }
                continue;
            }
            paras.add(value);
        }
        return paras.isEmpty() ? NULL_PARA_ARRAY : paras.toArray();
    }

    private static void addAll(List<Object> paras, int[] ints) {
        for (int i : ints) {
            paras.add(i);
        }
    }

    private static void addAll(List<Object> paras, long[] longs) {
        for (long i : longs) {
            paras.add(i);
        }
    }

    private static void addAll(List<Object> paras, short[] shorts) {
        for (short i : shorts) {
            paras.add(i);
        }
    }

    static String replaceSqlPara(String sql, Object value) {
        if (value == null) {
            return sql.replaceFirst("\\?", "null");
        }
        if (value instanceof Number) {
            return sql.replaceFirst("\\?", value.toString());
        }
        if (value instanceof String && StrUtil.isNumeric((String)value)) {
            return sql.replaceFirst("\\?", (String)value);
        }
        StringBuilder sb = new StringBuilder();
        if (value instanceof Date) {
            sb.append(DateKit.toStr((Date)((Date)value), (String)DateKit.timeStampPattern));
        } else {
            sb.append(value);
        }
        return sql.replaceFirst("\\?", Matcher.quoteReplacement(sb.toString()));
    }

    static String deleteWhitespace(String str) {
        int strLen = str.length();
        char[] chs = new char[strLen];
        int count = 0;
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            chs[count++] = str.charAt(i);
        }
        if (count == strLen) {
            return str;
        }
        return new String(chs, 0, count);
    }

    static String array2String(Object[] a) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append("-");
            ++i;
        }
    }

    static void checkNullParas(Columns columns, String name, Object ... paras) {
        if (columns.isUseSafeMode()) {
            for (Object obj : paras) {
                if (obj != null) continue;
                throw new NullPointerException("Column \"" + name + "\" para is null, Columns must has not null para value in safeMode.");
            }
        }
    }

    static void checkNullParas(Columns columns, Object ... paras) {
        if (columns.isUseSafeMode()) {
            for (Object obj : paras) {
                if (obj != null) continue;
                throw new NullPointerException("Columns must has not null para value in safeMode.");
            }
        }
    }

    static void checkNullParas(Columns columns, Collection<?> collection) {
        if (columns.isUseSafeMode() && CollectionUtil.isEmpty(collection)) {
            throw new NullPointerException("Columns must has not empty collection in safeMode.");
        }
    }
}

