/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.model;

import com.jfinal.kit.LogKit;
import com.jfinal.log.Log;
import com.jfinal.plugin.activerecord.ActiveRecordException;
import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.DbKit;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Table;
import com.jfinal.plugin.activerecord.dialect.Dialect;
import io.jboot.db.JbootDb;
import io.jboot.db.SqlDebugger;
import io.jboot.db.dialect.JbootDialect;
import io.jboot.db.model.Column;
import io.jboot.db.model.Columns;
import io.jboot.db.model.JbootModelConfig;
import io.jboot.db.model.Join;
import io.jboot.db.model.Joiner;
import io.jboot.db.model.Util;
import io.jboot.exception.JbootException;
import io.jboot.exception.JbootIllegalConfigException;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.StrUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class JbootModel<M extends JbootModel<M>>
extends Model<M> {
    private static final Log LOG = Log.getLog(JbootModel.class);
    private static final String DATASOURCE_CACHE_PREFIX = "__ds__";
    private static JbootModelConfig config = JbootModelConfig.getConfig();
    private static String column_created = config.getColumnCreated();
    private static String column_modified = config.getColumnModified();
    private static boolean idCacheEnable = config.isIdCacheEnable();
    protected List<Join> joins = null;
    String datasourceName = null;
    String alias = null;
    String loadColumns = null;
    boolean isCopyModel = false;
    private transient Table table;
    private transient String[] primaryKeys;
    private transient Class<?> primaryType;

    public Joiner<M> leftJoin(String table) {
        return this.joining(" LEFT JOIN ", table, true);
    }

    public Joiner<M> leftJoinIf(String table, boolean condition) {
        return this.joining(" LEFT JOIN ", table, condition);
    }

    public Joiner<M> rightJoin(String table) {
        return this.joining(" RIGHT JOIN ", table, true);
    }

    public Joiner<M> rightJoinIf(String table, boolean condition) {
        return this.joining(" RIGHT JOIN ", table, condition);
    }

    public Joiner<M> innerJoin(String table) {
        return this.joining(" INNER JOIN ", table, true);
    }

    public Joiner<M> innerJoinIf(String table, boolean condition) {
        return this.joining(" INNER JOIN ", table, condition);
    }

    public Joiner<M> fullJoin(String table) {
        return this.joining(" FULL JOIN ", table, true);
    }

    public Joiner<M> fullJoinIf(String table, boolean condition) {
        return this.joining(" FULL JOIN ", table, condition);
    }

    public M alias(String alias) {
        if (StrUtil.isBlank((String)alias)) {
            throw new IllegalArgumentException("alias must not be null or empty.");
        }
        M model = this.getOrCopyModel();
        ((JbootModel)((Object)model)).alias = alias;
        return model;
    }

    protected Joiner<M> joining(String type, String table, boolean condition) {
        M model = this.getOrCopyModel();
        if (((JbootModel)((Object)model)).joins == null) {
            ((JbootModel)((Object)model)).joins = new LinkedList<Join>();
        }
        Join join = new Join(type, table, condition);
        ((JbootModel)((Object)model)).joins.add(join);
        return new Joiner<M>(model, join);
    }

    public M loadColumns(String loadColumns) {
        if (StrUtil.isBlank((String)loadColumns)) {
            throw new IllegalArgumentException("loadColumns must not be null or empty.");
        }
        M model = this.getOrCopyModel();
        ((JbootModel)((Object)model)).loadColumns = loadColumns;
        return model;
    }

    public M distinct(String distinctColumnName) {
        if (StrUtil.isBlank((String)distinctColumnName)) {
            throw new IllegalArgumentException("distinctColumnName must not be null or empty.");
        }
        M model = this.getOrCopyModel();
        model.put("__ext_distinct", (Object)distinctColumnName);
        return model;
    }

    private M getOrCopyModel() {
        if (this.isCopyModel) {
            return (M)((Object)this);
        }
        M model = ((JbootModel)((Object)this.copy()))._setConfigName(this.datasourceName);
        ((JbootModel)((Object)model)).isCopyModel = true;
        return model;
    }

    public M copy() {
        JbootModel m = null;
        try {
            m = (JbootModel)((Object)this._getUsefulClass().newInstance());
            m.put(this._getAttrs());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return (M)((Object)m);
    }

    public M copyModel() {
        JbootModel m = null;
        try {
            m = (JbootModel)((Object)this._getUsefulClass().newInstance());
            Table table = this._getTable(true);
            Set attrKeys = table.getColumnTypeMap().keySet();
            for (String attrKey : attrKeys) {
                Object o = this.get(attrKey);
                if (o == null) continue;
                m.set(attrKey, o);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return (M)((Object)m);
    }

    public M use(String configName) {
        return this.use(configName, true);
    }

    public M useFirst(String ... configNames) {
        if (configNames == null || configNames.length == 0) {
            throw new IllegalArgumentException("configNames must not empty.");
        }
        for (String name : configNames) {
            M newDao = this.use(name, false);
            if (newDao == null) continue;
            return newDao;
        }
        return (M)((Object)this);
    }

    private M use(String configName, boolean validateExist) {
        JbootModel<M> newDao = (JbootModel)((Object)this.get(DATASOURCE_CACHE_PREFIX + configName));
        if (newDao == null) {
            newDao = ((JbootModel)((Object)this.copy()))._setConfigName(configName);
            if (newDao._getConfig() == null) {
                if (validateExist) {
                    throw new JbootIllegalConfigException("the datasource \"" + configName + "\" not config well, please config it in jboot.properties.");
                }
                return null;
            }
            this.put(DATASOURCE_CACHE_PREFIX + configName, newDao);
        }
        return (M)((Object)newDao);
    }

    M _setConfigName(String configName) {
        this.datasourceName = configName;
        return (M)((Object)this);
    }

    protected Config _getConfig() {
        if (this.datasourceName != null) {
            return DbKit.getConfig((String)this.datasourceName);
        }
        String currentConfigName = JbootDb.getCurrentConfigName();
        if (StrUtil.isNotBlank(currentConfigName)) {
            Config config = DbKit.getConfig((String)currentConfigName);
            if (config == null) {
                LogKit.error((String)"Can not use the datasource: {}, user default to replace.", (Object[])new Object[]{currentConfigName});
            } else {
                return config;
            }
        }
        return DbKit.getConfig((Class)this._getUsefulClass());
    }

    public boolean saveOrUpdate() {
        if (null == this._getIdValue()) {
            return this.save();
        }
        return this.update();
    }

    public boolean save() {
        Object value;
        String[] pkeys;
        if (this._hasColumn(column_created) && this.get(column_created) == null) {
            this.set(column_created, new Date());
        }
        if ((pkeys = this._getPrimaryKeys()) != null && pkeys.length == 1 && this.get(pkeys[0]) == null && (value = config.getPrimarykeyValueGenerator().genValue(this, this._getPrimaryType())) != null) {
            this.set(pkeys[0], value);
        }
        this.filter(0);
        Config config = this._getConfig();
        Table table = this._getTable();
        StringBuilder sql = new StringBuilder();
        ArrayList paras = new ArrayList();
        Dialect dialect = this._getConfig().getDialect();
        dialect.forModelSave(table, this._getAttrs(), sql, paras);
        try {
            return SqlDebugger.run(() -> {
                Boolean bl;
                Connection conn = null;
                PreparedStatement pst = null;
                int result = 0;
                try {
                    conn = config.getConnection();
                    pst = dialect.isOracle() ? conn.prepareStatement(sql.toString(), table.getPrimaryKey()) : conn.prepareStatement(sql.toString(), 1);
                    dialect.fillStatement(pst, paras);
                    result = pst.executeUpdate();
                    dialect.getModelGeneratedKey((Model)this, pst, table);
                    this._getModifyFlag().clear();
                    bl = result >= 1;
                }
                catch (Throwable throwable) {
                    config.close(pst, conn);
                    throw throwable;
                }
                config.close((Statement)pst, conn);
                return bl;
            }, config, sql.toString(), paras.toArray());
        }
        catch (SQLException e) {
            throw new ActiveRecordException((Throwable)e);
        }
    }

    protected void filter(int filterBy) {
        config.getFilter().filter(this, filterBy);
    }

    public M findById(Object idValue) {
        if (idValue == null) {
            return null;
        }
        return (M)(idCacheEnable ? this.loadByCache(idValue) : (JbootModel)super.findById(idValue));
    }

    public M findByIdWithoutCache(Object idValue) {
        if (idValue == null) {
            return null;
        }
        return (M)((Object)((JbootModel)super.findById(idValue)));
    }

    public M findByIds(Object ... idValues) {
        if (idValues == null) {
            return null;
        }
        if (idValues.length != this._getPrimaryKeys().length) {
            throw new IllegalArgumentException("idValues.length != _getPrimaryKeys().length");
        }
        return (M)(idCacheEnable ? this.loadByCache(idValues) : (JbootModel)super.findByIds(idValues));
    }

    public M findByIdsWithoutCache(Object ... idValues) {
        if (idValues == null) {
            return null;
        }
        if (idValues.length != this._getPrimaryKeys().length) {
            throw new IllegalArgumentException("idValues.length != _getPrimaryKeys().length");
        }
        return (M)((Object)((JbootModel)super.findByIds(idValues)));
    }

    protected M loadByCache(Object ... idValues) {
        try {
            JbootModel m = (JbootModel)((Object)config.getIdCache().get(this.buildIdCacheName(this._getTableName()), this.buildIdCacheKey(idValues), () -> (JbootModel)JbootModel.super.findByIds(idValues), config.getIdCacheTime()));
            return (M)(m != null && config.isIdCacheByCopyEnable() ? m.copy() : m);
        }
        catch (Exception ex) {
            LOG.error("Jboot load model [" + ClassUtil.getUsefulClass(((Object)((Object)this)).getClass()) + "] by cache is error, safe deleted it in cache.", (Throwable)ex);
            this.safeDeleteCache(idValues);
            return (M)((Object)((JbootModel)JbootModel.super.findByIds(idValues)));
        }
    }

    protected void safeDeleteCache(Object ... idValues) {
        try {
            config.getIdCache().remove(this.buildIdCacheName(this._getTableName()), this.buildIdCacheKey(idValues));
        }
        catch (Exception ex) {
            LOG.error("Remove cache is error by name [" + this.buildIdCacheName(this._getTableName()) + "] and key [" + this.buildIdCacheKey(idValues) + "]", (Throwable)ex);
        }
    }

    public boolean delete() {
        boolean success = super.delete();
        if (success && idCacheEnable) {
            this.deleteIdCache();
        }
        return success;
    }

    public boolean deleteById(Object idValue) {
        boolean success = super.deleteById(idValue);
        if (success && idCacheEnable) {
            this.deleteIdCacheById(idValue);
        }
        return success;
    }

    public boolean deleteByIds(Object ... idValues) {
        boolean success = super.deleteByIds(idValues);
        if (success && idCacheEnable) {
            this.deleteIdCacheById(idValues);
        }
        return success;
    }

    public boolean deleteByColumn(Column column) {
        if (column == null || !column.checkAvailable()) {
            throw new IllegalArgumentException("Column or value must not be null.");
        }
        return this.deleteByColumns(Arrays.asList(column));
    }

    public boolean deleteByColumns(Columns columns) {
        if (columns == null || columns.isEmpty()) {
            throw new IllegalArgumentException("Columns must not be null or empty.");
        }
        return this.deleteByColumns(columns.getList());
    }

    public boolean deleteByColumns(List<Column> columns) {
        if (columns == null || columns.isEmpty()) {
            throw new IllegalArgumentException("Columns must not be null or empty.");
        }
        String sql = this._getDialect().forDeleteByColumns(this.alias, this.joins, this._getTableName(), columns);
        return Db.use((String)this._getConfig().getName()).update(sql, Util.getValueArray(columns)) >= 1;
    }

    public boolean batchDeleteByIds(Object ... idValues) {
        if (idValues == null || idValues.length == 0) {
            return false;
        }
        boolean success = this.deleteByColumns(Columns.create().orEqs(this._getPrimaryKey(), idValues));
        if (success && idCacheEnable) {
            for (Object id : idValues) {
                this.deleteIdCacheById(id);
            }
        }
        return success;
    }

    public boolean update() {
        boolean success;
        if (this._hasColumn(column_modified)) {
            this.set(column_modified, new Date());
        }
        if ((success = super.update()) && idCacheEnable) {
            this.deleteIdCache();
        }
        return success;
    }

    public void deleteIdCache() {
        if (this._getPrimaryKeys().length == 1) {
            Object idValue = this.get(this._getPrimaryKey());
            this.deleteIdCacheById(idValue);
        } else {
            Object[] idvalues = new Object[this._getPrimaryKeys().length];
            for (int i = 0; i < idvalues.length; ++i) {
                idvalues[i] = this.get(this._getPrimaryKeys()[i]);
            }
            this.deleteIdCacheById(idvalues);
        }
    }

    public void deleteIdCacheById(Object ... idvalues) {
        this.safeDeleteCache(idvalues);
    }

    protected String buildIdCacheName(String orginal) {
        return orginal;
    }

    protected String buildIdCacheKey(Object ... idValues) {
        if (idValues == null || idValues.length == 0) {
            return null;
        }
        if (idValues.length == 1) {
            return idValues[0].toString();
        }
        StringBuilder key = new StringBuilder();
        for (int i = 0; i < idValues.length; ++i) {
            key.append(idValues[i]);
            if (i >= idValues.length - 1) continue;
            key.append(":");
        }
        return key.toString();
    }

    protected JbootDialect _getDialect() {
        Config config = this._getConfig();
        if (config == null) {
            return this.throwCannotMappingException();
        }
        return (JbootDialect)config.getDialect();
    }

    private JbootDialect throwCannotMappingException() {
        io.jboot.db.annotation.Table annotation = ((Object)((Object)this)).getClass().getAnnotation(io.jboot.db.annotation.Table.class);
        if (annotation != null && StrUtil.isNotBlank(annotation.datasource())) {
            throw new JbootException(String.format("Model \"%s\" can not mapping to datasource: " + annotation.datasource(), this._getUsefulClass().getName()));
        }
        throw new JbootException(String.format("Model \"%s\" can not mapping to database table, maybe application cannot connect to database. ", this._getUsefulClass().getName()));
    }

    public M findFirstByColumn(String column, Object value) {
        return this.findFirstByColumn(Column.create(column, value));
    }

    public M findFirstByColumn(String column, Object value, String orderBy) {
        return this.findFirstByColumn(Column.create(column, value), orderBy);
    }

    public M findFirstByColumn(Column column) {
        if (column == null || !column.checkAvailable()) {
            return null;
        }
        return this.findFirstByColumns(Columns.create(column));
    }

    public M findFirstByColumn(Column column, String orderBy) {
        if (column == null || !column.checkAvailable()) {
            return null;
        }
        return this.findFirstByColumns(Columns.create(column), orderBy);
    }

    public M findFirstByColumns(Columns columns) {
        return this.findFirstByColumns(columns, null);
    }

    public M findFirstByColumns(Columns columns, String orderby) {
        return this.findFirstByColumns(columns, orderby, null);
    }

    public M findFirstByColumns(Columns columns, String orderby, String loadColumns) {
        if (StrUtil.isBlank((String)loadColumns) && this.loadColumns != null) {
            loadColumns = this.loadColumns;
        }
        if (StrUtil.isBlank((String)loadColumns)) {
            loadColumns = "*";
        }
        String sql = this._getDialect().forFindByColumns(this.alias, this.joins, this._getTableName(), loadColumns, columns.getList(), orderby, 1);
        return (M)((Object)(columns.isEmpty() ? (JbootModel)this.findFirst(sql) : (JbootModel)this.findFirst(sql, columns.getValueArray())));
    }

    public List<M> findListByIds(Object ... ids) {
        if (ids == null || ids.length == 0) {
            return null;
        }
        ArrayList<Model> list = new ArrayList<Model>();
        for (Object id : ids) {
            if (id.getClass() == int[].class) {
                this.findListByIds((List<M>)list, (int[])id);
                continue;
            }
            if (id.getClass() == long[].class) {
                this.findListByIds(list, (long[])id);
                continue;
            }
            if (id.getClass() == short[].class) {
                this.findListByIds((List<M>)list, (short[])id);
                continue;
            }
            Model model = this.findById(id);
            if (model == null) continue;
            list.add(model);
        }
        return list;
    }

    private void findListByIds(List<M> list, int[] ids) {
        for (int id : ids) {
            Model model = this.findById(id);
            if (model == null) continue;
            list.add(model);
        }
    }

    private void findListByIds(List<M> list, long[] ids) {
        for (long id : ids) {
            Model model = this.findById(id);
            if (model == null) continue;
            list.add(model);
        }
    }

    private void findListByIds(List<M> list, short[] ids) {
        for (short id : ids) {
            Model model = this.findById(id);
            if (model == null) continue;
            list.add(model);
        }
    }

    public List<M> findListByColumn(String column, Object value) {
        return this.findListByColumn(Column.create(column, value), null, null);
    }

    public List<M> findListByColumn(Column column) {
        return this.findListByColumn(column, null, null);
    }

    public List<M> findListByColumn(String column, Object value, Integer count) {
        return this.findListByColumn(Column.create(column, value), null, count);
    }

    public List<M> findListByColumn(Column column, Integer count) {
        return this.findListByColumn(column, null, count);
    }

    public List<M> findListByColumn(String column, Object value, String orderBy) {
        return this.findListByColumn(Column.create(column, value), orderBy, null);
    }

    public List<M> findListByColumn(Column column, String orderby) {
        return this.findListByColumn(column, orderby, null);
    }

    public List<M> findListByColumn(String column, Object value, String orderBy, Integer count) {
        return this.findListByColumn(Column.create(column, value), orderBy, count);
    }

    public List<M> findListByColumn(Column column, String orderBy, Integer count) {
        if (column == null || !column.checkAvailable()) {
            return null;
        }
        return this.findListByColumns(Columns.create(column), orderBy, count);
    }

    public List<M> findListByColumns(List<Column> columns) {
        return this.findListByColumns(columns, null, null);
    }

    public List<M> findListByColumns(List<Column> columns, String orderBy) {
        return this.findListByColumns(columns, orderBy, null);
    }

    public List<M> findListByColumns(List<Column> columns, Integer count) {
        return this.findListByColumns(columns, null, count);
    }

    public List<M> findListByColumns(List<Column> columns, String orderBy, Integer count) {
        return this.findListByColumns(Columns.create(columns), orderBy, count);
    }

    public List<M> findListByColumns(Columns columns) {
        return this.findListByColumns(columns, null, null);
    }

    public List<M> findListByColumns(Columns columns, String orderBy) {
        return this.findListByColumns(columns, orderBy, null);
    }

    public List<M> findListByColumns(Columns columns, Integer count) {
        return this.findListByColumns(columns, null, count);
    }

    public List<M> findListByColumns(Columns columns, String orderBy, Integer count) {
        return this.findListByColumns(columns, orderBy, count, null);
    }

    public List<M> findListByColumns(Columns columns, String orderBy, Integer count, String loadColumns) {
        if (StrUtil.isBlank((String)loadColumns) && this.loadColumns != null) {
            loadColumns = this.loadColumns;
        }
        if (StrUtil.isBlank((String)loadColumns)) {
            String distinctColumn = (String)this.get("__ext_distinct");
            loadColumns = this.hasAnyJoinEffective() && StrUtil.isNotBlank(distinctColumn) ? "DISTINCT " + distinctColumn + "," + (StrUtil.isNotBlank(this.alias) ? this.alias : this._getTableName()) + ".*" : "*";
        }
        String sql = this._getDialect().forFindByColumns(this.alias, this.joins, this._getTableName(), loadColumns, columns.getList(), orderBy, count);
        return columns.isEmpty() ? this.find(sql) : this.find(sql, columns.getValueArray());
    }

    boolean hasAnyJoinEffective() {
        if (this.joins == null || this.joins.size() == 0) {
            return false;
        }
        for (Join join : this.joins) {
            if (!join.isEffective()) continue;
            return true;
        }
        return false;
    }

    public Page<M> paginate(int pageNumber, int pageSize) {
        return this.paginateByColumns(pageNumber, pageSize, Columns.create(), null);
    }

    public Page<M> paginate(int pageNumber, int pageSize, String orderBy) {
        return this.paginateByColumns(pageNumber, pageSize, Columns.create(), orderBy);
    }

    public Page<M> paginateByColumn(int pageNumber, int pageSize, Column column) {
        return this.paginateByColumns(pageNumber, pageSize, Columns.create(column), null);
    }

    public Page<M> paginateByColumn(int pageNumber, int pageSize, Column column, String orderBy) {
        return this.paginateByColumns(pageNumber, pageSize, Columns.create(column), orderBy);
    }

    public Page<M> paginateByColumns(int pageNumber, int pageSize, Columns columns) {
        return this.paginateByColumns(pageNumber, pageSize, columns, null);
    }

    public Page<M> paginateByColumns(int pageNumber, int pageSize, List<Column> columns) {
        return this.paginateByColumns(pageNumber, pageSize, columns, null);
    }

    public Page<M> paginateByColumns(int pageNumber, int pageSize, List<Column> columns, String orderBy) {
        return this.paginateByColumns(pageNumber, pageSize, Columns.create(columns), orderBy);
    }

    public Page<M> paginateByColumns(int pageNumber, int pageSize, Columns columns, String orderBy) {
        return this.paginateByColumns(pageNumber, pageSize, columns, orderBy, null);
    }

    public Page<M> paginateByColumns(int pageNumber, int pageSize, Columns columns, String orderBy, String loadColumns) {
        if (StrUtil.isBlank((String)loadColumns) && this.loadColumns != null) {
            loadColumns = this.loadColumns;
        }
        if (StrUtil.isBlank((String)loadColumns)) {
            String distinctColumn = (String)this.get("__ext_distinct");
            loadColumns = this.hasAnyJoinEffective() && StrUtil.isNotBlank(distinctColumn) ? "DISTINCT " + distinctColumn + "," + (StrUtil.isNotBlank(this.alias) ? this.alias : this._getTableName()) + ".*" : "*";
        }
        String selectPartSql = this._getDialect().forPaginateSelect(loadColumns);
        String fromPartSql = this._getDialect().forPaginateFrom(this.alias, this.joins, this._getTableName(), columns.getList(), orderBy);
        Config config = this._getConfig();
        Connection conn = null;
        try {
            conn = config.getConnection();
            String totalRowSqlExceptSelect = this._getDialect().forPaginateFrom(this.alias, this.joins, this._getTableName(), columns.getList(), null);
            String totalRowSql = config.getDialect().forPaginateTotalRow(selectPartSql, totalRowSqlExceptSelect, (Object)this);
            StringBuilder findSql = new StringBuilder();
            findSql.append(selectPartSql).append(' ').append(fromPartSql);
            Page page = this.doPaginateByFullSql(config, conn, pageNumber, pageSize, null, totalRowSql, findSql, columns.getValueArray());
            return page;
        }
        catch (Exception e) {
            throw new ActiveRecordException((Throwable)e);
        }
        finally {
            config.close(conn);
        }
    }

    public long findCountByColumn(Column column) {
        return this.findCountByColumns(Columns.create(column));
    }

    public long findCountByColumns(Columns columns) {
        String loadColumns = "*";
        if (this.hasAnyJoinEffective() && StrUtil.isNotBlank(this.get("__ext_distinct"))) {
            loadColumns = "DISTINCT " + this.get("__ext_distinct");
        }
        String sql = this._getDialect().forFindCountByColumns(this.alias, this.joins, this._getTableName(), loadColumns, columns.getList());
        Long value = Db.use((String)this._getConfig().getName()).queryLong(sql, Util.getValueArray(columns.getList()));
        return value == null ? 0L : value;
    }

    public <T> T _getIdValue() {
        return (T)this.get(this._getPrimaryKey());
    }

    public Object[] _getIdValues() {
        String[] pkeys = this._getPrimaryKeys();
        Object[] values = new Object[pkeys.length];
        int i = 0;
        for (String key : pkeys) {
            values[i++] = this.get(key);
        }
        return values;
    }

    public String _getTableName() {
        return this._getTable(true).getName();
    }

    public Table _getTable() {
        return this._getTable(false);
    }

    public Table _getTable(boolean validateMapping) {
        if (this.table == null) {
            this.table = super._getTable();
            if (this.table == null && validateMapping) {
                this.throwCannotMappingException();
            }
        }
        return this.table;
    }

    public String _getPrimaryKey() {
        return this._getPrimaryKeys()[0];
    }

    public String[] _getPrimaryKeys() {
        if (this.primaryKeys != null) {
            return this.primaryKeys;
        }
        this.primaryKeys = this._getTable(true).getPrimaryKey();
        if (this.primaryKeys == null) {
            throw new JbootException(String.format("primaryKeys == null in [%s]", ((Object)((Object)this)).getClass()));
        }
        return this.primaryKeys;
    }

    protected Class<?> _getPrimaryType() {
        if (this.primaryType == null) {
            this.primaryType = this._getTable(true).getColumnType(this._getPrimaryKey());
        }
        return this.primaryType;
    }

    protected boolean _hasColumn(String columnLabel) {
        return this._getTable(true).hasColumnLabel(columnLabel);
    }

    public boolean equals(Object o) {
        if (!(o instanceof JbootModel)) {
            return false;
        }
        if (this._getTable(false) == null) {
            return this == o;
        }
        Object id = ((JbootModel)((Object)o))._getIdValue();
        return id != null && id.equals(this._getIdValue());
    }

    public int hashCode() {
        if (this._getTable(false) == null) {
            return Objects.hash(this._getAttrValues());
        }
        Object[] idValues = this._getIdValues();
        return idValues.length > 0 ? Objects.hash(idValues) : Objects.hash(this._getAttrValues());
    }

    public M preventXssAttack() {
        String[] attrNames;
        for (String attrName : attrNames = this._getAttrNames()) {
            Object value = this.get(attrName);
            if (!(value instanceof String)) continue;
            this.set(attrName, StrUtil.escapeHtml((String)value));
        }
        return (M)((Object)this);
    }

    public M preventXssAttack(String ... ignoreAttrs) {
        String[] attrNames;
        for (String attrName : attrNames = this._getAttrNames()) {
            Object value = this.get(attrName);
            if (!(value instanceof String)) continue;
            boolean isIgnoreAttr = false;
            for (String ignoreAttr : ignoreAttrs) {
                if (!attrName.equals(ignoreAttr)) continue;
                isIgnoreAttr = true;
                break;
            }
            if (isIgnoreAttr) continue;
            this.set(attrName, StrUtil.escapeHtml((String)value));
        }
        return (M)((Object)this);
    }

    protected List<M> find(Config config, Connection conn, String sql, Object ... paras) throws Exception {
        return SqlDebugger.run(() -> {
            try {
                return super.find(config, conn, sql, paras);
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw new SQLException(e);
            }
        }, config, sql, paras);
    }

    public BigInteger getBigInteger(String attr) {
        Object data = this._getAttrs().get(attr);
        if (data instanceof BigInteger) {
            return (BigInteger)data;
        }
        if (data instanceof BigDecimal) {
            return ((BigDecimal)data).toBigInteger();
        }
        if (data instanceof Number) {
            return BigInteger.valueOf(((Number)data).longValue());
        }
        return (BigInteger)data;
    }

    public BigDecimal getBigDecimal(String attr) {
        Object data = this._getAttrs().get(attr);
        if (data instanceof BigDecimal) {
            return (BigDecimal)data;
        }
        if (data instanceof Number) {
            return new BigDecimal(data.toString());
        }
        return (BigDecimal)data;
    }
}

