/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.model;

import io.jboot.db.dialect.JbootMysqlDialect;
import io.jboot.db.dialect.JbootSqlServerDialect;
import io.jboot.db.model.Column;
import io.jboot.db.model.Group;
import io.jboot.db.model.GroupBy;
import io.jboot.db.model.Having;
import io.jboot.db.model.Or;
import io.jboot.db.model.SqlBuilder;
import io.jboot.db.model.SqlPart;
import io.jboot.db.model.Util;
import io.jboot.utils.StrUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class Columns
implements Serializable {
    public static final Columns EMPTY = Columns.create();
    private List<Column> cols;
    private boolean useSafeMode = false;
    private static final char SQL_CACHE_SEPARATOR = '-';

    public static Columns create() {
        return new Columns();
    }

    public static Columns create(Column column) {
        Columns that = new Columns();
        that.add(column);
        return that;
    }

    public static Columns create(List<Column> columns) {
        Columns that = new Columns();
        that.cols = columns;
        return that;
    }

    public static Columns create(String name, Object value) {
        return Columns.create().eq(name, value);
    }

    public static Columns safeMode() {
        return new Columns().useSafeMode();
    }

    public static Columns safeCreate(String name, Object value) {
        return Columns.safeMode().eq(name, value);
    }

    public Columns add(Column column) {
        if (column.hasPara() && column.getValue() == null) {
            return this;
        }
        if (this.cols == null) {
            this.cols = new LinkedList<Column>();
        }
        this.cols.add(column);
        return this;
    }

    public Columns addToFirst(Column column) {
        if (column.hasPara() && column.getValue() == null) {
            return this;
        }
        if (this.cols == null) {
            this.cols = new LinkedList<Column>();
        }
        this.cols.add(0, column);
        return this;
    }

    public Columns add(Columns columns) {
        return this.append(columns);
    }

    public Columns addToFirst(Columns columns) {
        if (columns != null && !columns.isEmpty()) {
            for (Column column : columns.getList()) {
                this.addToFirst(column);
            }
        }
        return this;
    }

    public Columns eq(String name, Object value) {
        Util.checkNullParas(this, name, value);
        return this.add(Column.create(name, value));
    }

    public Columns ne(String name, Object value) {
        Util.checkNullParas(this, name, value);
        return this.add(Column.create(name, value, "!="));
    }

    public Columns like(String name, Object value) {
        Util.checkNullParas(this, name, value);
        return this.add(Column.create(name, value, "LIKE"));
    }

    public Columns likeAppendPercent(String name, Object value) {
        Util.checkNullParas(this, name, value);
        if (value == null || value instanceof String && StrUtil.isBlank((String)((String)value))) {
            return this;
        }
        return this.add(Column.create(name, "%" + value + "%", "LIKE"));
    }

    public Columns gt(String name, Object value) {
        Util.checkNullParas(this, name, value);
        return this.add(Column.create(name, value, ">"));
    }

    public Columns ge(String name, Object value) {
        Util.checkNullParas(this, name, value);
        return this.add(Column.create(name, value, ">="));
    }

    public Columns lt(String name, Object value) {
        Util.checkNullParas(this, name, value);
        return this.add(Column.create(name, value, "<"));
    }

    public Columns le(String name, Object value) {
        Util.checkNullParas(this, name, value);
        return this.add(Column.create(name, value, "<="));
    }

    public Columns isNull(String name) {
        return this.add(Column.create(name, null, "IS NULL"));
    }

    public Columns isNullIf(String name, boolean condition) {
        if (condition) {
            this.add(Column.create(name, null, "IS NULL"));
        }
        return this;
    }

    public Columns isNotNull(String name) {
        return this.add(Column.create(name, null, "IS NOT NULL"));
    }

    public Columns isNotNullIf(String name, boolean condition) {
        if (condition) {
            this.add(Column.create(name, null, "IS NOT NULL"));
        }
        return this;
    }

    public Columns in(String name, Object ... arrays) {
        Util.checkNullParas(this, name, arrays);
        return this.add(Column.create(name, arrays, "IN"));
    }

    public Columns in(String name, Collection collection) {
        Util.checkNullParas(this, collection);
        if (collection != null && !collection.isEmpty()) {
            this.in(name, collection.toArray());
        }
        return this;
    }

    public Columns notIn(String name, Object ... arrays) {
        Util.checkNullParas(this, name, arrays);
        return this.add(Column.create(name, arrays, "NOT IN"));
    }

    public Columns notIn(String name, Collection collection) {
        Util.checkNullParas(this, collection);
        if (collection != null && !collection.isEmpty()) {
            this.notIn(name, collection.toArray());
        }
        return this;
    }

    public Columns between(String name, Object start, Object end) {
        Util.checkNullParas(this, name, start, end);
        return this.add(Column.create(name, new Object[]{start, end}, "BETWEEN"));
    }

    public Columns notBetween(String name, Object start, Object end) {
        Util.checkNullParas(this, name, start, end);
        return this.add(Column.create(name, new Object[]{start, end}, "NOT BETWEEN"));
    }

    public Columns group(Columns columns) {
        if (columns == this) {
            throw new IllegalArgumentException("Columns.group(...) need a new Columns");
        }
        if (!columns.isEmpty()) {
            this.add(new Group(columns));
        }
        return this;
    }

    public Columns groupIf(Columns columns, boolean conditon) {
        if (columns == this) {
            throw new IllegalArgumentException("Columns.group(...) need a new Columns");
        }
        if (conditon && !columns.isEmpty()) {
            this.add(new Group(columns));
        }
        return this;
    }

    public Columns groupBy(String name) {
        this.add(new GroupBy(name));
        return this;
    }

    public Columns having(String name) {
        this.add(new Having(name));
        return this;
    }

    public Columns having(String sql, Object ... paras) {
        this.add(new Having(sql, paras));
        return this;
    }

    public Columns having(Columns columns) {
        this.add(new Having(columns));
        return this;
    }

    public Columns sqlPart(String sql) {
        if (StrUtil.isNotBlank(sql)) {
            this.add(new SqlPart(sql));
        }
        return this;
    }

    public Columns sqlPart(String sql, Object ... paras) {
        Util.checkNullParas(this, paras);
        if (StrUtil.isNotBlank(sql)) {
            this.add(new SqlPart(sql, paras));
        }
        return this;
    }

    public Columns sqlPartIf(String sql, boolean condition) {
        if (condition && StrUtil.isNotBlank(sql)) {
            this.add(new SqlPart(sql));
        }
        return this;
    }

    public Columns sqlPartIf(String sql, boolean condition, Object ... paras) {
        Util.checkNullParas(this, paras);
        if (condition && StrUtil.isNotBlank(sql)) {
            this.add(new SqlPart(sql, paras));
        }
        return this;
    }

    public Columns sqlPartWithoutLink(String sql) {
        if (StrUtil.isNotBlank(sql)) {
            this.add(new SqlPart(sql, true));
        }
        return this;
    }

    public Columns sqlPartWithoutLink(String sql, Object ... paras) {
        Util.checkNullParas(this, paras);
        if (StrUtil.isNotBlank(sql)) {
            this.add(new SqlPart(sql, paras, true));
        }
        return this;
    }

    public Columns sqlPartWithoutLinkIf(String sql, boolean condition) {
        if (condition && StrUtil.isNotBlank(sql)) {
            this.add(new SqlPart(sql, true));
        }
        return this;
    }

    public Columns sqlPartWithoutLinkIf(String sql, boolean condition, Object ... paras) {
        Util.checkNullParas(this, paras);
        if (condition && StrUtil.isNotBlank(sql)) {
            this.add(new SqlPart(sql, paras, true));
        }
        return this;
    }

    public Columns or() {
        this.add(new Or());
        return this;
    }

    public Columns ors(String name, String logic, Object ... values) {
        Util.checkNullParas(this, name, values);
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (value == null) continue;
            this.add(Column.create(name, value, logic));
            if (i == values.length - 1) continue;
            this.add(new Or());
        }
        return this;
    }

    public Columns orEqs(String name, Object ... values) {
        return this.ors(name, "=", values);
    }

    public Columns append(Columns columns) {
        if (columns != null && !columns.isEmpty()) {
            for (Column column : columns.getList()) {
                this.add(column);
            }
        }
        return this;
    }

    public Columns appendIf(Columns columns, boolean condition) {
        if (condition) {
            this.append(columns);
        }
        return this;
    }

    public boolean isUseSafeMode() {
        return this.useSafeMode;
    }

    public Columns useSafeMode() {
        this.useSafeMode = true;
        return this;
    }

    public Columns unUseSafeMode() {
        this.useSafeMode = false;
        return this;
    }

    public boolean isEmpty() {
        return this.cols == null || this.cols.isEmpty();
    }

    public Object[] getValueArray() {
        return Util.getValueArray(this.cols);
    }

    public List<Column> getList() {
        return this.cols;
    }

    public boolean containsName(String name) {
        if (this.isEmpty()) {
            return false;
        }
        for (Column col : this.cols) {
            if (col.getName() == null || !col.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public String getCacheKey() {
        if (this.isEmpty()) {
            return null;
        }
        ArrayList<Column> columns = new ArrayList<Column>(this.cols);
        StringBuilder s = new StringBuilder();
        this.buildCacheKey(s, columns);
        return s.toString();
    }

    private void buildCacheKey(StringBuilder s, List<Column> columns) {
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            if (column instanceof Or) {
                Column before;
                Column column2 = before = i > 0 ? columns.get(i - 1) : null;
                if (before == null || before instanceof Or) continue;
                s.append("or").append('-');
                continue;
            }
            if (column instanceof Group) {
                s.append('(');
                this.buildCacheKey(s, ((Group)column).getColumns().getList());
                s.append(')').append('-');
                continue;
            }
            if (column instanceof SqlPart) {
                String sqlpart = ((SqlPart)column).getSql();
                Object value = column.getValue();
                if (value != null) {
                    if (value.getClass().isArray()) {
                        Object[] values;
                        for (Object v : values = (Object[])value) {
                            sqlpart = Util.replaceSqlPara(sqlpart, v);
                        }
                    } else {
                        sqlpart = Util.replaceSqlPara(sqlpart, value);
                    }
                }
                s.append(Util.deleteWhitespace(sqlpart)).append('-');
                continue;
            }
            s.append(column.getName()).append('-').append(Columns.getLogicString(column.getLogic())).append('-');
            Object value = column.getValue();
            if (value == null) continue;
            if (value.getClass().isArray()) {
                s.append(Util.array2String((Object[])value));
            } else {
                s.append(column.getValue());
            }
            s.append('-');
        }
        s.deleteCharAt(s.length() - 1);
    }

    private static String getLogicString(String logic) {
        switch (logic) {
            case "LIKE": {
                return "lk";
            }
            case ">": {
                return "gt";
            }
            case ">=": {
                return "ge";
            }
            case "<": {
                return "lt";
            }
            case "<=": {
                return "le";
            }
            case "=": {
                return "eq";
            }
            case "!=": {
                return "neq";
            }
            case "IS NULL": {
                return "isn";
            }
            case "IS NOT NULL": {
                return "nn";
            }
            case "IN": {
                return "in";
            }
            case "NOT IN": {
                return "nin";
            }
            case "BETWEEN": {
                return "bt";
            }
            case "NOT BETWEEN": {
                return "nbt";
            }
        }
        return "";
    }

    public String toWherePartSql() {
        return this.toWherePartSql('`', false);
    }

    public String toWherePartSql(boolean withWhereKeyword) {
        return this.toWherePartSql('`', withWhereKeyword);
    }

    public String toWherePartSql(char separator, boolean withWhereKeyword) {
        StringBuilder sb = new StringBuilder();
        SqlBuilder.buildWhereSql(sb, this.getList(), separator, withWhereKeyword);
        return sb.toString();
    }

    public String toString() {
        return this.getCacheKey();
    }

    public static void main(String[] args) {
        Columns columns = Columns.create().useSafeMode().or().or().or().eq("aa", "bb").or().or().or().notIn("aaa", 123, 456, 789).like("titile", "a");
        columns.group(Columns.create().or().or().sqlPart("aa=bb"));
        columns.group(Columns.create("aa", "bb").eq("cc", "dd").group(Columns.create("aa", "bb").eq("cc", "dd")).group(Columns.create("aa", "bb").eq("cc", "dd").group(Columns.create("aa", "bb").eq("cc", "dd"))));
        columns.ge("age", 10);
        columns.or();
        columns.or();
        columns.or();
        columns.or();
        columns.sqlPart("user.id != ? and xxx= ?", 1, "abc2");
        columns.sqlPart("user.id != ? and xxx= ?", 1, "abc2");
        columns.or();
        columns.or();
        columns.or();
        columns.group(Columns.create().likeAppendPercent("name", "null").or().or().or().eq("age", "18").eq("ddd", null));
        columns.or();
        columns.or();
        columns.group(Columns.create().or().or().sqlPart("name = ?", "zhangsan"));
        columns.or();
        columns.or();
        columns.or();
        columns.between("name", "123", "1233");
        columns.between("name", "123", "1233");
        columns.or();
        columns.groupBy("aaa").having(Columns.create("aaa", "bbb").ge("ccc", 111));
        System.out.println(columns.getCacheKey());
        System.out.println(Arrays.toString(columns.getValueArray()));
        System.out.println(columns.toMysqlSql());
        System.out.println("-----------");
        System.out.println(columns.toWherePartSql('\"', true));
    }

    private String toMysqlSql() {
        JbootMysqlDialect dialect = new JbootMysqlDialect();
        return dialect.forFindByColumns(null, null, "table", "*", this.getList(), null, null);
    }

    private String toSqlServerSql() {
        JbootSqlServerDialect dialect = new JbootSqlServerDialect();
        return dialect.forFindByColumns(null, null, "table", "*", this.getList(), null, null);
    }
}

