/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.driver;

import com.google.common.collect.MapMaker;
import io.jboot.db.driver.OfficialClickHouseConnection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.clickhouse.ClickHouseConnection;
import ru.yandex.clickhouse.ClickHouseDriver;
import ru.yandex.clickhouse.settings.ClickHouseProperties;
import ru.yandex.clickhouse.util.LogProxy;

public class OfficialClickHouseDriver
extends ClickHouseDriver {
    private static final Logger logger = LoggerFactory.getLogger(ClickHouseDriver.class);
    private static final ConcurrentMap<OfficialClickHouseConnection, Boolean> connections = new MapMaker().weakKeys().makeMap();

    public OfficialClickHouseDriver() {
        this.scheduleConnectionsCleaning(10, TimeUnit.SECONDS);
    }

    public ClickHouseConnection connect(String url, ClickHouseProperties properties) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        OfficialClickHouseConnection connection = new OfficialClickHouseConnection(url, properties);
        this.registerConnection(connection);
        return (ClickHouseConnection)LogProxy.wrap(ClickHouseConnection.class, (Object)((Object)connection));
    }

    private void registerConnection(OfficialClickHouseConnection connection) {
        connections.put(connection, Boolean.TRUE);
    }

    public void scheduleConnectionsCleaning(int rate, TimeUnit timeUnit) {
        ScheduledConnectionCleaner.INSTANCE.scheduleAtFixedRate(() -> {
            try {
                for (OfficialClickHouseConnection connection : connections.keySet()) {
                    connection.cleanConnections();
                }
            }
            catch (Exception e) {
                logger.error("error evicting connections: " + e);
            }
        }, 0L, rate, timeUnit);
    }

    static {
        try {
            DriverManager.registerDriver((Driver)((Object)new OfficialClickHouseDriver()));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    static class ScheduledConnectionCleaner {
        static final ScheduledExecutorService INSTANCE = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory());

        ScheduledConnectionCleaner() {
        }

        static class DaemonThreadFactory
        implements ThreadFactory {
            DaemonThreadFactory() {
            }

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = Executors.defaultThreadFactory().newThread(r);
                thread.setDaemon(true);
                return thread;
            }
        }
    }
}

