/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.driver;

import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.http.impl.client.CloseableHttpClient;
import ru.yandex.clickhouse.ClickHouseConnectionImpl;
import ru.yandex.clickhouse.ClickhouseJdbcUrlParser;
import ru.yandex.clickhouse.settings.ClickHouseProperties;

public class OfficialClickHouseConnection
extends ClickHouseConnectionImpl {
    private ClickHouseProperties properties;

    public OfficialClickHouseConnection(String url) throws SQLException {
        super(url);
        try {
            this.properties = ClickhouseJdbcUrlParser.parse((String)url, (Properties)new Properties());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public OfficialClickHouseConnection(String url, ClickHouseProperties properties) throws SQLException {
        super(url, properties);
        try {
            this.properties = ClickhouseJdbcUrlParser.parse((String)url, (Properties)properties.asProperties());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement(sql);
    }

    public void cleanConnections() {
        try {
            Field httpClientField = ClickHouseConnectionImpl.class.getDeclaredField("httpclient");
            httpClientField.setAccessible(true);
            CloseableHttpClient httpclient = (CloseableHttpClient)httpClientField.get((Object)this);
            if (httpclient != null) {
                httpclient.getConnectionManager().closeExpiredConnections();
                httpclient.getConnectionManager().closeIdleConnections((long)(2 * this.properties.getSocketTimeout()), TimeUnit.MILLISECONDS);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

