/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.driver;

import com.github.housepower.jdbc.ClickHouseConnection;
import com.github.housepower.jdbc.ClickHouseDriver;
import com.github.housepower.jdbc.settings.ClickHouseConfig;
import io.jboot.db.driver.NativeClickHouseConnection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class NativeClickHouseDriver
extends ClickHouseDriver {
    public ClickHouseConnection connect(String url, Properties properties) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        ClickHouseConfig cfg = ClickHouseConfig.Builder.builder().withJdbcUrl(url).withProperties(properties).build();
        return this.connect(url, cfg);
    }

    ClickHouseConnection connect(String url, ClickHouseConfig cfg) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        return NativeClickHouseConnection.createClickHouseConnection(cfg.withJdbcUrl(url));
    }

    static {
        try {
            DriverManager.registerDriver((Driver)((Object)new NativeClickHouseDriver()));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

