/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.driver;

import com.github.housepower.jdbc.ClickHouseConnection;
import com.github.housepower.jdbc.connect.NativeClient;
import com.github.housepower.jdbc.connect.NativeContext;
import com.github.housepower.jdbc.misc.Validate;
import com.github.housepower.jdbc.protocol.HelloResponse;
import com.github.housepower.jdbc.protocol.QueryRequest;
import com.github.housepower.jdbc.settings.ClickHouseConfig;
import java.net.InetSocketAddress;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.Locale;

public class NativeClickHouseConnection
extends ClickHouseConnection {
    protected NativeClickHouseConnection(ClickHouseConfig cfg, NativeContext nativeCtx) {
        super(cfg, nativeCtx);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement(sql);
    }

    public static ClickHouseConnection createClickHouseConnection(ClickHouseConfig configure) throws SQLException {
        return new NativeClickHouseConnection(configure, NativeClickHouseConnection.createNativeContext(configure));
    }

    private static NativeContext createNativeContext(ClickHouseConfig configure) throws SQLException {
        NativeClient nativeClient = NativeClient.connect((ClickHouseConfig)configure);
        return new NativeContext(NativeClickHouseConnection.clientContext(nativeClient, configure), NativeClickHouseConnection.serverContext(nativeClient, configure), nativeClient);
    }

    private static QueryRequest.ClientContext clientContext(NativeClient nativeClient, ClickHouseConfig configure) throws SQLException {
        Validate.isTrue((boolean)(nativeClient.address() instanceof InetSocketAddress));
        InetSocketAddress address = (InetSocketAddress)nativeClient.address();
        String clientName = String.format(Locale.ROOT, "%s %s", "ClickHouse", "client");
        String initialAddress = "[::ffff:127.0.0.1]:0";
        return new QueryRequest.ClientContext(initialAddress, address.getHostName(), clientName);
    }

    private static NativeContext.ServerContext serverContext(NativeClient nativeClient, ClickHouseConfig configure) throws SQLException {
        try {
            long revision = 54380L;
            nativeClient.sendHello("client", revision, configure.database(), configure.user(), configure.password());
            HelloResponse response = nativeClient.receiveHello(configure.queryTimeout(), null);
            ZoneId timeZone = ZoneId.of(response.serverTimeZone());
            return new NativeContext.ServerContext(response.majorVersion(), response.minorVersion(), response.reversion(), configure, timeZone, response.serverDisplayName());
        }
        catch (SQLException rethrows) {
            nativeClient.silentDisconnect();
            throw rethrows;
        }
    }
}

