/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.driver;

import io.jboot.utils.ClassUtil;
import io.jboot.utils.StrUtil;
import java.util.HashMap;
import java.util.Map;

public class DriverClassNames {
    private static final Map<String, String[]> driverClassNames = new HashMap<String, String[]>();
    private static final Map<String, String> jbootDriverMapping;

    public static String getDefaultDriverClass(String type) {
        String[] drivers = driverClassNames.get(type.toLowerCase());
        if (drivers == null || drivers.length == 0) {
            return null;
        }
        for (String driver : drivers) {
            if (!ClassUtil.hasClass(driver)) continue;
            String jbootDriver = jbootDriverMapping.get(driver);
            return StrUtil.isNotBlank(jbootDriver) ? jbootDriver : driver;
        }
        return null;
    }

    static {
        driverClassNames.put("mysql", new String[]{"com.mysql.cj.jdbc.Driver", "com.mysql.jdbc.Driver"});
        driverClassNames.put("oracle", new String[]{"oracle.jdbc.driver.OracleDriver", "oracle.jdbc.OracleDriver"});
        driverClassNames.put("sqlserver", new String[]{"com.microsoft.sqlserver.jdbc.SQLServerDriver"});
        driverClassNames.put("sqlite", new String[]{"org.sqlite.JDBC"});
        driverClassNames.put("postgresql", new String[]{"org.postgresql.Driver"});
        driverClassNames.put("clickhouse", new String[]{"com.github.housepower.jdbc.ClickHouseDriver", "ru.yandex.clickhouse.ClickHouseDriver"});
        driverClassNames.put("informix", new String[]{"com.informix.jdbc.IfxDriver"});
        jbootDriverMapping = new HashMap<String, String>();
        jbootDriverMapping.put("com.github.housepower.jdbc.ClickHouseDriver", "io.jboot.db.driver.NativeClickHouseDriver");
        jbootDriverMapping.put("ru.yandex.clickhouse.ClickHouseDriver", "io.jboot.db.driver.OfficialClickHouseDriver");
    }
}

