/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.dialect;

import com.jfinal.plugin.activerecord.dialect.SqlServerDialect;
import io.jboot.db.dialect.JbootDialect;
import io.jboot.db.model.Column;
import io.jboot.db.model.Join;
import io.jboot.db.model.SqlBuilder;
import io.jboot.exception.JbootException;
import java.util.List;

public class JbootSqlServerDialect
extends SqlServerDialect
implements JbootDialect {
    @Override
    public String forFindByColumns(String alias, List<Join> joins, String table, String loadColumns, List<Column> columns, String orderBy, Object limit) {
        StringBuilder sqlBuilder = SqlBuilder.forFindByColumns(alias, joins, table, loadColumns, columns, orderBy, ' ');
        if (limit == null) {
            return sqlBuilder.toString();
        }
        if (limit instanceof Number) {
            StringBuilder ret = new StringBuilder();
            ret.append("SELECT * FROM ( SELECT row_number() over (order by tempcolumn) temprownumber, * FROM ");
            ret.append(" ( SELECT TOP ").append(limit).append(" tempcolumn=0,");
            ret.append(sqlBuilder.toString().replaceFirst("(?i)select", ""));
            ret.append(")vip)mvp ");
            return ret.toString();
        }
        if (limit instanceof String && limit.toString().contains(",")) {
            String[] startAndEnd = limit.toString().split(",");
            String start = startAndEnd[0];
            String end = startAndEnd[1];
            StringBuilder ret = new StringBuilder();
            ret.append("SELECT * FROM ( SELECT row_number() over (order by tempcolumn) temprownumber, * FROM ");
            ret.append(" ( SELECT TOP ").append(end).append(" tempcolumn=0,");
            ret.append(sqlBuilder.toString().replaceFirst("(?i)select", ""));
            ret.append(")vip)mvp where temprownumber>").append(start);
            return ret.toString();
        }
        throw new JbootException("sql limit is error!,limit must is Number of String like \"0,10\"");
    }

    @Override
    public String forFindCountByColumns(String alias, List<Join> joins, String table, String loadColumns, List<Column> columns) {
        return SqlBuilder.forFindCountByColumns(alias, joins, table, loadColumns, columns, ' ');
    }

    @Override
    public String forDeleteByColumns(String alias, List<Join> joins, String table, List<Column> columns) {
        return SqlBuilder.forDeleteByColumns(alias, joins, table, columns, ' ');
    }

    @Override
    public String forPaginateSelect(String loadColumns) {
        return "SELECT " + loadColumns;
    }

    @Override
    public String forPaginateFrom(String alias, List<Join> joins, String table, List<Column> columns, String orderBy) {
        return SqlBuilder.forPaginateFrom(alias, joins, table, columns, orderBy, ' ');
    }

    public String forPaginateTotalRow(String select, String sqlExceptSelect, Object ext) {
        String distinctSql = SqlBuilder.forPaginateDistinctTotalRow(select, sqlExceptSelect, ext);
        return distinctSql != null ? distinctSql : super.forPaginateTotalRow(select, sqlExceptSelect, ext);
    }
}

