/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.dialect;

import com.jfinal.plugin.activerecord.CPI;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.Table;
import com.jfinal.plugin.activerecord.dialect.AnsiSqlDialect;
import io.jboot.db.dialect.JbootDialect;
import io.jboot.db.model.Column;
import io.jboot.db.model.JbootModel;
import io.jboot.db.model.Join;
import io.jboot.db.model.SqlBuilder;
import io.jboot.utils.StrUtil;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JbootClickHouseDialect
extends AnsiSqlDialect
implements JbootDialect {
    public void getModelGeneratedKey(Model<?> model, PreparedStatement pst, Table table) throws SQLException {
    }

    public String forDbDeleteById(String tableName, String[] pKeys) {
        tableName = tableName.trim();
        this.trimPrimaryKeys(pKeys);
        StringBuilder sql = new StringBuilder("ALTER TABLE ").append(tableName).append(" DELETE WHERE ");
        for (int i = 0; i < pKeys.length; ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append(pKeys[i]).append(" = ?");
        }
        return sql.toString();
    }

    public String forModelDeleteById(Table table) {
        String[] pKeys = table.getPrimaryKey();
        StringBuilder sql = new StringBuilder(45);
        sql.append("ALTER TABLE ");
        sql.append(table.getName());
        sql.append(" DELETE WHERE ");
        for (int i = 0; i < pKeys.length; ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append(pKeys[i]).append(" = ?");
        }
        return sql.toString();
    }

    public void forDbUpdate(String tableName, String[] pKeys, Object[] ids, Record record, StringBuilder sql, List<Object> paras) {
        tableName = tableName.trim();
        this.trimPrimaryKeys(pKeys);
        sql.append("ALTER TABLE ").append(tableName).append(" UPDATE ");
        for (Map.Entry e : record.getColumns().entrySet()) {
            String colName = (String)e.getKey();
            if (this.isPrimaryKey(colName, pKeys)) continue;
            if (paras.size() > 0) {
                sql.append(", ");
            }
            sql.append(colName).append(" = ? ");
            paras.add(e.getValue());
        }
        sql.append(" WHERE ");
        for (int i = 0; i < pKeys.length; ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append(pKeys[i]).append(" = ?");
            paras.add(ids[i]);
        }
    }

    public void forModelUpdate(Table table, Map<String, Object> attrs, Set<String> modifyFlag, StringBuilder sql, List<Object> paras) {
        sql.append("ALTER TABLE ").append(table.getName()).append(" UPDATE ");
        String[] pKeys = table.getPrimaryKey();
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            String colName = e.getKey();
            if (!modifyFlag.contains(colName) || this.isPrimaryKey(colName, pKeys) || !table.hasColumnLabel(colName)) continue;
            if (paras.size() > 0) {
                sql.append(", ");
            }
            sql.append(colName).append(" = ? ");
            paras.add(e.getValue());
        }
        sql.append(" WHERE ");
        for (int i = 0; i < pKeys.length; ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append(pKeys[i]).append(" = ?");
            paras.add(attrs.get(pKeys[i]));
        }
    }

    @Override
    public String forFindByColumns(String alias, List<Join> joins, String table, String loadColumns, List<Column> columns, String orderBy, Object limit) {
        StringBuilder sqlBuilder = SqlBuilder.forFindByColumns(alias, joins, table, loadColumns, columns, orderBy, ' ');
        if (limit != null) {
            sqlBuilder.append(" LIMIT " + limit);
        }
        return sqlBuilder.toString();
    }

    @Override
    public String forFindCountByColumns(String alias, List<Join> joins, String table, String loadColumns, List<Column> columns) {
        return SqlBuilder.forFindCountByColumns(alias, joins, table, loadColumns, columns, ' ');
    }

    @Override
    public String forDeleteByColumns(String alias, List<Join> joins, String table, List<Column> columns) {
        StringBuilder sqlBuilder = new StringBuilder(45);
        sqlBuilder.append("ALTER TABLE ").append(table).append(" DELETE ");
        SqlBuilder.buildJoinSql(sqlBuilder, joins, ' ');
        SqlBuilder.buildWhereSql(sqlBuilder, columns, ' ');
        return sqlBuilder.toString();
    }

    @Override
    public String forPaginateSelect(String loadColumns) {
        return "SELECT " + loadColumns;
    }

    @Override
    public String forPaginateFrom(String alias, List<Join> joins, String table, List<Column> columns, String orderBy) {
        return SqlBuilder.forPaginateFrom(alias, joins, table, columns, orderBy, ' ');
    }

    public String forPaginateTotalRow(String select, String sqlExceptSelect, Object ext) {
        if (ext instanceof Model) {
            if (io.jboot.db.model.CPI.hasAnyJoinEffective((JbootModel)((Object)ext))) {
                String distinct = (String)((JbootModel)((Object)ext)).get("__ext_distinct");
                if (StrUtil.isNotBlank(distinct)) {
                    return "SELECT count(DISTINCT " + distinct + ") " + this.replaceOrderBy(sqlExceptSelect);
                }
            } else {
                String[] primaryKeys = CPI.getTable((Model)((Model)ext)).getPrimaryKey();
                if (primaryKeys != null && primaryKeys.length == 1) {
                    return "select count(" + primaryKeys[0] + ") " + this.replaceOrderBy(sqlExceptSelect);
                }
            }
        }
        return super.forPaginateTotalRow(select, sqlExceptSelect, ext);
    }
}

