/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.datasource;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import io.jboot.aop.InterceptorBuilder;
import io.jboot.aop.Interceptors;
import io.jboot.aop.annotation.AutoLoad;
import io.jboot.db.JbootDb;
import io.jboot.db.annotation.PriorDatasource;
import io.jboot.utils.AnnotationUtil;
import io.jboot.utils.StrUtil;
import java.lang.reflect.Method;

@AutoLoad
public class PriorDatasourceInterceptor
implements Interceptor,
InterceptorBuilder {
    public void intercept(Invocation inv) {
        String configName;
        PriorDatasource datasource = this.getAnnotation(inv);
        if (datasource != null && StrUtil.isNotBlank(configName = AnnotationUtil.get(datasource.value()))) {
            JbootDb.setCurrentConfigName(configName);
        }
        inv.invoke();
    }

    private PriorDatasource getAnnotation(Invocation inv) {
        PriorDatasource annotation = inv.getController().getClass().getAnnotation(PriorDatasource.class);
        return annotation != null ? annotation : inv.getMethod().getAnnotation(PriorDatasource.class);
    }

    @Override
    public void build(Class<?> targetClass, Method method, Interceptors interceptors) {
        if (InterceptorBuilder.Util.hasAnnotation(targetClass, PriorDatasource.class) || InterceptorBuilder.Util.hasAnnotation(method, PriorDatasource.class)) {
            interceptors.add(this);
        }
    }
}

