/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db.datasource;

import io.jboot.db.datasource.DataSourceConfig;
import io.jboot.utils.ConfigUtil;
import io.jboot.utils.StrUtil;
import java.util.HashMap;
import java.util.Map;

public class DataSourceConfigManager {
    private static DataSourceConfigManager manager = new DataSourceConfigManager();
    private Map<String, DataSourceConfig> datasourceConfigs = new HashMap<String, DataSourceConfig>();

    public static DataSourceConfigManager me() {
        return manager;
    }

    private DataSourceConfigManager() {
        Map<String, DataSourceConfig> configMap = ConfigUtil.getConfigModels(DataSourceConfig.class, "jboot.datasource");
        for (Map.Entry<String, DataSourceConfig> entry : configMap.entrySet()) {
            DataSourceConfig config = entry.getValue();
            if ("default".equals(entry.getKey()) && StrUtil.isBlank((String)config.getName())) {
                config.setName("main");
            } else if (StrUtil.isBlank((String)config.getName())) {
                config.setName(entry.getKey());
            }
            this.addConfig(config);
        }
    }

    public void addConfig(DataSourceConfig config) {
        if (config == null || !config.isConfigOk()) {
            return;
        }
        this.datasourceConfigs.put(config.getName(), config);
    }

    public Map<String, DataSourceConfig> getDatasourceConfigs() {
        return this.datasourceConfigs;
    }

    public DataSourceConfig getMainDatasourceConfig() {
        return this.datasourceConfigs.get("main");
    }
}

