/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db;

import com.jfinal.plugin.activerecord.Model;
import io.jboot.db.TableInfo;
import io.jboot.db.annotation.Table;
import io.jboot.db.datasource.DataSourceConfig;
import io.jboot.db.model.JbootModelConfig;
import io.jboot.utils.AnnotationUtil;
import io.jboot.utils.ArrayUtil;
import io.jboot.utils.ClassScanner;
import io.jboot.utils.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TableInfoManager {
    private List<TableInfo> allTableInfos;
    private static TableInfoManager instance = new TableInfoManager();

    public static TableInfoManager me() {
        return instance;
    }

    public void initConfigMappingTables(DataSourceConfig dataSourceConfig) {
        Set<String> configTables = StrUtil.isNotBlank(dataSourceConfig.getTable()) ? StrUtil.splitToSetByComma(dataSourceConfig.getTable()) : null;
        Set<String> configExTables = StrUtil.isNotBlank(dataSourceConfig.getExTable()) ? StrUtil.splitToSetByComma(dataSourceConfig.getExTable()) : null;
        List<TableInfo> allTableInfos = this.getAllTableInfos();
        for (TableInfo tableInfo : allTableInfos) {
            if (configExTables != null && configExTables.contains(tableInfo.getTableName())) continue;
            if (configTables != null && configTables.contains(tableInfo.getTableName())) {
                dataSourceConfig.addTableInfo(tableInfo, true);
            }
            if (tableInfo.getDatasourceNames().contains(dataSourceConfig.getName())) {
                dataSourceConfig.addTableInfo(tableInfo, true);
            }
            if (configExTables != null && configExTables.contains("*") || tableInfo.getDatasourceNames().size() > 0 || configTables != null && configTables.size() > 0) continue;
            dataSourceConfig.addTableInfo(tableInfo, false);
        }
    }

    private List<TableInfo> getAllTableInfos() {
        if (this.allTableInfos == null) {
            this.allTableInfos = new ArrayList<TableInfo>();
            this.initTableInfos(this.allTableInfos);
        }
        return this.allTableInfos;
    }

    private void initTableInfos(List<TableInfo> tableInfoList) {
        List<Class<Model>> modelClassList = ClassScanner.scanSubClass(Model.class);
        if (ArrayUtil.isNullOrEmpty(modelClassList)) {
            return;
        }
        String scanPackage = JbootModelConfig.getConfig().getScanPackage();
        String unscanPackage = JbootModelConfig.getConfig().getUnscanPackage();
        for (Class<Model> clazz : modelClassList) {
            Table tb = clazz.getAnnotation(Table.class);
            if (tb == null) continue;
            if (StrUtil.isNotBlank(scanPackage) && clazz.getName().startsWith(scanPackage.trim())) {
                this.addTable(tableInfoList, clazz, tb);
                continue;
            }
            if (StrUtil.isNotBlank(unscanPackage) && ("*".equals(unscanPackage.trim()) || clazz.getName().startsWith(unscanPackage.trim()))) continue;
            this.addTable(tableInfoList, clazz, tb);
        }
    }

    private void addTable(List<TableInfo> tableInfoList, Class<Model> modelClass, Table tb) {
        TableInfo tableInfo = new TableInfo();
        tableInfo.setModelClass(modelClass);
        tableInfo.setPrimaryKey(AnnotationUtil.get(tb.primaryKey()));
        tableInfo.setTableName(AnnotationUtil.get(tb.tableName()));
        tableInfo.setDatasource(AnnotationUtil.get(tb.datasource()));
        tableInfoList.add(tableInfo);
    }
}

