/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db;

import com.jfinal.plugin.activerecord.Model;
import io.jboot.db.datasource.DataSourceConfig;
import io.jboot.utils.StrUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TableInfo {
    private String tableName;
    private String primaryKey;
    private Class<? extends Model> modelClass;
    private String datasource;
    private Set<String> datasourceNames;
    private List<DataSourceConfigWrapper> attachedDatasources;

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public Class<? extends Model> getModelClass() {
        return this.modelClass;
    }

    public void setModelClass(Class<? extends Model> modelClass) {
        this.modelClass = modelClass;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    public Set<String> getDatasourceNames() {
        if (this.datasourceNames == null) {
            this.datasourceNames = StrUtil.isNotBlank(this.datasource) ? StrUtil.splitToSetByComma(this.datasource) : new HashSet();
        }
        return this.datasourceNames;
    }

    public boolean addAttachedDatasource(DataSourceConfig dataSourceConfig, boolean fromDesignated) {
        if (this.attachedDatasources == null) {
            this.attachedDatasources = new ArrayList<DataSourceConfigWrapper>();
        }
        if (!fromDesignated && !this.attachedDatasources.isEmpty()) {
            return false;
        }
        if (fromDesignated && !this.attachedDatasources.isEmpty()) {
            for (DataSourceConfigWrapper dataSourceConfigWrapper2 : this.attachedDatasources) {
                if (dataSourceConfigWrapper2.fromDesignated) continue;
                dataSourceConfigWrapper2.dataSourceConfig.removeTableInfo(this);
            }
            this.attachedDatasources.removeIf(dataSourceConfigWrapper -> !((DataSourceConfigWrapper)dataSourceConfigWrapper).fromDesignated);
        }
        if (this.attachedDatasources.isEmpty()) {
            this.attachedDatasources.add(new DataSourceConfigWrapper(dataSourceConfig, fromDesignated));
        }
        return true;
    }

    public static class DataSourceConfigWrapper {
        private final DataSourceConfig dataSourceConfig;
        private final boolean fromDesignated;

        public DataSourceConfigWrapper(DataSourceConfig dataSourceConfig, boolean fromDesignated) {
            this.dataSourceConfig = dataSourceConfig;
            this.fromDesignated = fromDesignated;
        }
    }
}

