/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db;

import com.jfinal.log.Log;
import com.jfinal.plugin.activerecord.Config;
import io.jboot.Jboot;
import io.jboot.utils.DateUtil;
import io.jboot.utils.StrUtil;
import java.sql.SQLException;
import java.util.Date;
import java.util.regex.Matcher;

public class SqlDebugger {
    private static SqlDebugPrinter printer = SqlDebugPrinter.DEFAULT_PRINTER;

    public static SqlDebugPrinter getPrinter() {
        return printer;
    }

    public static void setPrinter(SqlDebugPrinter printer) {
        SqlDebugger.printer = printer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T run(SqlRunner<T> runner, Config config, String sql, Object ... paras) throws SQLException {
        if (!printer.isPrintEnable(config)) {
            return runner.run();
        }
        long timeMillis = System.currentTimeMillis();
        try {
            T t = runner.run();
            return t;
        }
        finally {
            SqlDebugger.doDebug(System.currentTimeMillis() - timeMillis, sql, paras);
        }
    }

    private static void doDebug(Long takedTimeMillis, String sql, Object ... paras) {
        if (paras != null) {
            for (Object value : paras) {
                if (value == null) {
                    sql = sql.replaceFirst("\\?", "null");
                    continue;
                }
                if (value instanceof Number || value instanceof Boolean) {
                    sql = sql.replaceFirst("\\?", value.toString());
                    continue;
                }
                if (value instanceof String && StrUtil.isNumeric((String)value)) {
                    sql = sql.replaceFirst("\\?", (String)value);
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("'");
                if (value instanceof Date) {
                    sb.append(DateUtil.toDateTimeString((Date)value));
                } else {
                    sb.append(value);
                }
                sb.append("'");
                sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(sb.toString()));
            }
        }
        printer.print(sql, takedTimeMillis);
    }

    public static interface SqlRunner<V> {
        public V run() throws SQLException;
    }

    public static interface SqlDebugPrinter {
        public static final SqlDebugPrinter DEFAULT_PRINTER = new SqlDebugPrinter(){
            private boolean printSqlEnable = Jboot.isDevMode();

            @Override
            public void setPrintEnable(boolean enable) {
                this.printSqlEnable = enable;
            }

            @Override
            public boolean isPrintEnable(Config config) {
                return this.printSqlEnable;
            }

            @Override
            public void print(String sql, Long takedTimeMillis) {
                if (takedTimeMillis != null) {
                    System.out.println("Jboot exec sql taked " + takedTimeMillis + " ms >>>  " + sql);
                } else {
                    System.out.println("Jboot exec sql >>>  " + sql);
                }
            }
        };
        public static final SqlDebugPrinter LOG_PRINTER = new SqlDebugPrinter(){
            private boolean printSqlEnable = Jboot.isDevMode();
            private Log log = Log.getLog((String)"SqlDebugPrinter.LogPrinter");

            @Override
            public void setPrintEnable(boolean enable) {
                this.printSqlEnable = enable;
            }

            @Override
            public boolean isPrintEnable(Config config) {
                return this.printSqlEnable;
            }

            @Override
            public void print(String sql, Long takedTimeMillis) {
                if (takedTimeMillis != null) {
                    this.log.debug("Jboot exec sql taked " + takedTimeMillis + " ms >>>  " + sql);
                } else {
                    this.log.debug("Jboot exec sql >>>  " + sql);
                }
            }
        };

        public void setPrintEnable(boolean var1);

        public boolean isPrintEnable(Config var1);

        public void print(String var1, Long var2);
    }
}

