/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db;

import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.Record;
import io.jboot.db.dbpro.JbootDbPro;
import io.jboot.db.model.Columns;
import io.jboot.utils.StrUtil;
import java.util.List;

public class JbootDb
extends Db {
    private static ThreadLocal<String> CONFIG_NAME_TL = new ThreadLocal();

    public static String getCurrentConfigName() {
        return CONFIG_NAME_TL.get();
    }

    public static void setCurrentConfigName(String configName) {
        CONFIG_NAME_TL.set(configName);
    }

    public static void clearCurrentConfigName() {
        CONFIG_NAME_TL.remove();
    }

    public static JbootDbPro use(String configName) {
        return (JbootDbPro)Db.use((String)configName);
    }

    public static JbootDbPro use() {
        String currentConfigName = JbootDb.getCurrentConfigName();
        return StrUtil.isBlank((String)currentConfigName) ? (JbootDbPro)Db.use() : JbootDb.use(currentConfigName);
    }

    public static List<Record> find(String tableName, Columns columns) {
        return JbootDb.find(tableName, columns, null, null);
    }

    public static List<Record> find(String tableName, Columns columns, String orderBy) {
        return JbootDb.find(tableName, columns, orderBy, null);
    }

    public static List<Record> find(String tableName, Columns columns, Object limit) {
        return JbootDb.find(tableName, columns, null, limit);
    }

    public static List<Record> find(String tableName, Columns columns, String orderBy, Object limit) {
        return JbootDb.use().find(tableName, columns, orderBy, limit);
    }

    public static Record findFirst(String tableName, Columns columns) {
        return JbootDb.findFirst(tableName, columns, null);
    }

    public static Record findFirst(String tableName, Columns columns, String orderBy) {
        List<Record> records = JbootDb.use().find(tableName, columns, orderBy, (Object)1);
        return records != null && !records.isEmpty() ? records.get(0) : null;
    }

    public static int delete(String tableName, Columns columns) {
        return JbootDb.use().delete(tableName, columns);
    }
}

