/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.db;

import com.jfinal.plugin.activerecord.ActiveRecordPlugin;
import com.jfinal.plugin.activerecord.CaseInsensitiveContainerFactory;
import com.jfinal.plugin.activerecord.IContainerFactory;
import com.jfinal.plugin.activerecord.IDbProFactory;
import com.jfinal.plugin.activerecord.RecordBuilder;
import com.jfinal.plugin.activerecord.cache.ICache;
import com.jfinal.plugin.activerecord.dialect.Dialect;
import io.jboot.Jboot;
import io.jboot.components.cache.JbootCache;
import io.jboot.db.TableInfo;
import io.jboot.db.TableInfoManager;
import io.jboot.db.datasource.DataSourceBuilder;
import io.jboot.db.datasource.DataSourceConfig;
import io.jboot.db.datasource.DataSourceConfigManager;
import io.jboot.db.dbpro.JbootDbProFactory;
import io.jboot.db.dialect.JbootAnsiSqlDialect;
import io.jboot.db.dialect.JbootClickHouseDialect;
import io.jboot.db.dialect.JbootInformixDialect;
import io.jboot.db.dialect.JbootMysqlDialect;
import io.jboot.db.dialect.JbootOracleDialect;
import io.jboot.db.dialect.JbootPostgreSqlDialect;
import io.jboot.db.dialect.JbootSqlServerDialect;
import io.jboot.db.dialect.JbootSqlite3Dialect;
import io.jboot.db.record.JbootRecordBuilder;
import io.jboot.exception.JbootException;
import io.jboot.exception.JbootIllegalConfigException;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.StrUtil;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;

public class ArpManager {
    private static ArpManager instance;
    private List<ActiveRecordPlugin> activeRecordPlugins = new ArrayList<ActiveRecordPlugin>();

    public static ArpManager me() {
        if (instance == null) {
            instance = new ArpManager();
        }
        return instance;
    }

    private ArpManager() {
        Map<String, DataSourceConfig> datasourceConfigs = DataSourceConfigManager.me().getDatasourceConfigs();
        this.createdRecordPlugins(datasourceConfigs);
    }

    private void createdRecordPlugins(Map<String, DataSourceConfig> allConfigs) {
        HashMap<Integer, DataSourceConfig> dsCache = new HashMap<Integer, DataSourceConfig>();
        DataSourceConfig mainDataSourceConfig = allConfigs.remove("main");
        this.initRecordPlugin(dsCache, mainDataSourceConfig);
        for (Map.Entry<String, DataSourceConfig> entry : allConfigs.entrySet()) {
            this.initRecordPlugin(dsCache, entry.getValue());
        }
        for (ActiveRecordPlugin activeRecordPlugin : this.activeRecordPlugins) {
            DataSourceConfig dataSourceConfig = (DataSourceConfig)dsCache.get(System.identityHashCode(activeRecordPlugin));
            List<TableInfo> tableInfos = dataSourceConfig.getTableInfos();
            if (tableInfos == null || tableInfos.isEmpty()) continue;
            for (TableInfo table : tableInfos) {
                String tableName;
                String string = tableName = StrUtil.isNotBlank(dataSourceConfig.getTablePrefix()) ? dataSourceConfig.getTablePrefix() + table.getTableName() : table.getTableName();
                if (StrUtil.isNotBlank(table.getPrimaryKey())) {
                    activeRecordPlugin.addMapping(tableName, table.getPrimaryKey(), table.getModelClass());
                    continue;
                }
                activeRecordPlugin.addMapping(tableName, table.getModelClass());
            }
        }
    }

    private void initRecordPlugin(Map<Integer, DataSourceConfig> arpDatasourceConfigs, DataSourceConfig datasourceConfig) {
        if (datasourceConfig != null && datasourceConfig.isConfigOk()) {
            ActiveRecordPlugin activeRecordPlugin = this.createRecordPlugin(datasourceConfig);
            arpDatasourceConfigs.put(System.identityHashCode(activeRecordPlugin), datasourceConfig);
            this.activeRecordPlugins.add(activeRecordPlugin);
        }
    }

    public ActiveRecordPlugin createRecordPlugin(DataSourceConfig config) {
        ActiveRecordPlugin activeRecordPlugin = this.newRecordPlugin(config);
        if (StrUtil.isNotBlank(config.getDbProFactory())) {
            IDbProFactory dbProFactory = (IDbProFactory)Objects.requireNonNull(ClassUtil.newInstance(config.getDbProFactory()), "Can not create dbProfactory by class: " + config.getDbProFactory());
            activeRecordPlugin.setDbProFactory(dbProFactory);
        } else {
            activeRecordPlugin.setDbProFactory((IDbProFactory)new JbootDbProFactory());
        }
        if (StrUtil.isNotBlank(config.getContainerFactory())) {
            activeRecordPlugin.setContainerFactory((IContainerFactory)ClassUtil.newInstance(config.getContainerFactory()));
        }
        if (config.getTransactionLevel() != null) {
            activeRecordPlugin.setTransactionLevel(config.getTransactionLevel().intValue());
        }
        activeRecordPlugin.setShowSql(false);
        JbootCache jbootCache = Jboot.getCache();
        if (jbootCache != null) {
            activeRecordPlugin.setCache((ICache)jbootCache);
        }
        this.configSqlTemplate(activeRecordPlugin, config);
        this.configDialect(activeRecordPlugin, config);
        activeRecordPlugin.getConfig().getDialect().setRecordBuilder((RecordBuilder)new JbootRecordBuilder());
        if (config.isNeedAddMapping()) {
            TableInfoManager.me().initConfigMappingTables(config);
        }
        return activeRecordPlugin;
    }

    private ActiveRecordPlugin newRecordPlugin(DataSourceConfig config) {
        String configName = config.getName();
        DataSource dataSource = new DataSourceBuilder(config).build();
        String clazzName = config.getActiveRecordPluginClass();
        if (StrUtil.isBlank((String)clazzName)) {
            return StrUtil.isNotBlank(configName) ? new ActiveRecordPlugin(configName, dataSource) : new ActiveRecordPlugin(dataSource);
        }
        try {
            Class<?> arpc = Class.forName(clazzName, false, Thread.currentThread().getContextClassLoader());
            if (StrUtil.isNotBlank(configName)) {
                Constructor<?> constructor = arpc.getConstructor(String.class, DataSource.class);
                return (ActiveRecordPlugin)constructor.newInstance(configName, dataSource);
            }
            Constructor<?> constructor = arpc.getConstructor(DataSource.class);
            return (ActiveRecordPlugin)constructor.newInstance(dataSource);
        }
        catch (Exception e) {
            throw new JbootException(e.toString(), e);
        }
    }

    private void configSqlTemplate(ActiveRecordPlugin activeRecordPlugin, DataSourceConfig datasourceConfig) {
        String sqlTemplatePath = datasourceConfig.getSqlTemplatePath();
        if (StrUtil.isNotBlank(sqlTemplatePath)) {
            activeRecordPlugin.setBaseSqlTemplatePath(sqlTemplatePath);
        } else {
            activeRecordPlugin.setBaseSqlTemplatePath(null);
        }
        String sqlTemplateString = datasourceConfig.getSqlTemplate();
        if (sqlTemplateString != null) {
            String[] sqlTemplateFiles;
            for (String sql : sqlTemplateFiles = sqlTemplateString.split(",")) {
                activeRecordPlugin.addSqlTemplate(sql);
            }
        }
    }

    private void configDialect(ActiveRecordPlugin activeRecordPlugin, DataSourceConfig datasourceConfig) {
        if (datasourceConfig.getDialectClass() != null) {
            Dialect dialect = (Dialect)ClassUtil.newInstance(datasourceConfig.getDialectClass(), false);
            if (dialect == null) {
                throw new NullPointerException("can not new instance by class:" + datasourceConfig.getDialectClass());
            }
            activeRecordPlugin.setDialect(dialect);
            return;
        }
        switch (datasourceConfig.getType()) {
            case "mysql": {
                activeRecordPlugin.setDialect((Dialect)new JbootMysqlDialect());
                break;
            }
            case "oracle": {
                if (StrUtil.isBlank((String)datasourceConfig.getContainerFactory())) {
                    activeRecordPlugin.setContainerFactory((IContainerFactory)new CaseInsensitiveContainerFactory());
                }
                activeRecordPlugin.setDialect((Dialect)new JbootOracleDialect());
                break;
            }
            case "sqlserver": {
                activeRecordPlugin.setDialect((Dialect)new JbootSqlServerDialect());
                break;
            }
            case "sqlite": {
                activeRecordPlugin.setDialect((Dialect)new JbootSqlite3Dialect());
                break;
            }
            case "ansisql": {
                activeRecordPlugin.setDialect((Dialect)new JbootAnsiSqlDialect());
                break;
            }
            case "postgresql": {
                activeRecordPlugin.setDialect((Dialect)new JbootPostgreSqlDialect());
                break;
            }
            case "clickhouse": {
                activeRecordPlugin.setDialect((Dialect)new JbootClickHouseDialect());
                break;
            }
            case "informix": {
                activeRecordPlugin.setDialect((Dialect)new JbootInformixDialect());
                break;
            }
            default: {
                throw new JbootIllegalConfigException("only support datasource type : mysql\u3001orcale\u3001sqlserver\u3001sqlite\u3001ansisql\u3001postgresql and clickhouse, please check your jboot.properties. ");
            }
        }
    }

    public List<ActiveRecordPlugin> getActiveRecordPlugins() {
        return this.activeRecordPlugins;
    }
}

