/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.core.log;

import com.jfinal.log.Log;
import io.jboot.exception.JbootExceptionHolder;
import org.slf4j.Logger;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class Slf4jSimpleLogger
extends Log {
    private Logger log;

    public Slf4jSimpleLogger(Logger log) {
        this.log = log;
    }

    public void debug(String message) {
        this.log.debug(message);
    }

    public void debug(String message, Throwable t) {
        this.log.debug(message, t);
    }

    public void info(String message) {
        this.log.info(message);
    }

    public void info(String message, Throwable t) {
        this.log.info(message, t);
    }

    public void warn(String message) {
        this.log.warn(message);
    }

    public void warn(String message, Throwable t) {
        this.log.warn(message, t);
    }

    public void error(String message) {
        this.log.error(message);
    }

    public void error(String message, Throwable t) {
        JbootExceptionHolder.hold(message, t);
        this.log.error(message, t);
    }

    public void fatal(String message) {
        this.log.error(message);
    }

    public void fatal(String message, Throwable t) {
        JbootExceptionHolder.hold(message, t);
        this.log.error(message, t);
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.log.isErrorEnabled();
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public void trace(String message) {
        this.log.trace(message);
    }

    public void trace(String message, Throwable t) {
        this.log.trace(message, t);
    }

    public void trace(String format, Object ... args) {
        if (this.isTraceEnabled()) {
            this.log.trace(format, args);
        }
    }

    public void debug(String format, Object ... args) {
        if (this.isDebugEnabled()) {
            this.log.debug(format, args);
        }
    }

    public void info(String format, Object ... args) {
        if (this.isInfoEnabled()) {
            this.log.info(format, args);
        }
    }

    public void warn(String format, Object ... args) {
        if (this.isWarnEnabled()) {
            this.log.warn(format, args);
        }
    }

    public void error(String format, Object ... args) {
        if (this.isErrorEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])args);
            JbootExceptionHolder.hold(ft.getMessage(), ft.getThrowable());
            this.log.error(format, args);
        }
    }

    public void fatal(String format, Object ... args) {
        if (this.isFatalEnabled()) {
            this.log.error(format, args);
        }
    }
}

