/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.core.log;

import com.jfinal.log.Log;
import io.jboot.exception.JbootExceptionHolder;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jLogger
extends Log {
    private LocationAwareLogger log;
    private static final Object[] NULL_ARGS = new Object[0];
    private static final String callerFQCN = Slf4jLogger.class.getName();

    public Slf4jLogger(LocationAwareLogger log) {
        this.log = log;
    }

    public void trace(String message) {
        this.log.log(null, callerFQCN, 0, message, NULL_ARGS, null);
    }

    public void trace(String message, Throwable t) {
        this.log.log(null, callerFQCN, 0, message, NULL_ARGS, t);
    }

    public void debug(String message) {
        this.log.log(null, callerFQCN, 10, message, NULL_ARGS, null);
    }

    public void debug(String message, Throwable t) {
        this.log.log(null, callerFQCN, 10, message, NULL_ARGS, t);
    }

    public void info(String message) {
        this.log.log(null, callerFQCN, 20, message, NULL_ARGS, null);
    }

    public void info(String message, Throwable t) {
        this.log.log(null, callerFQCN, 20, message, NULL_ARGS, t);
    }

    public void warn(String message) {
        this.log.log(null, callerFQCN, 30, message, NULL_ARGS, null);
    }

    public void warn(String message, Throwable t) {
        this.log.log(null, callerFQCN, 30, message, NULL_ARGS, t);
    }

    public void error(String message) {
        JbootExceptionHolder.hold(message, null);
        this.log.log(null, callerFQCN, 40, message, NULL_ARGS, null);
    }

    public void error(String message, Throwable t) {
        JbootExceptionHolder.hold(message, t);
        this.log.log(null, callerFQCN, 40, message, NULL_ARGS, t);
    }

    public void fatal(String message) {
        this.log.log(null, callerFQCN, 40, message, NULL_ARGS, null);
    }

    public void fatal(String message, Throwable t) {
        JbootExceptionHolder.hold(message, t);
        this.log.log(null, callerFQCN, 40, message, NULL_ARGS, t);
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.log.isErrorEnabled();
    }

    public void trace(String format, Object ... args) {
        if (this.isTraceEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])args);
            this.log.log(null, callerFQCN, 0, ft.getMessage(), NULL_ARGS, ft.getThrowable());
        }
    }

    public void debug(String format, Object ... args) {
        if (this.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])args);
            this.log.log(null, callerFQCN, 10, ft.getMessage(), NULL_ARGS, ft.getThrowable());
        }
    }

    public void info(String format, Object ... args) {
        if (this.isInfoEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])args);
            this.log.log(null, callerFQCN, 20, ft.getMessage(), NULL_ARGS, ft.getThrowable());
        }
    }

    public void warn(String format, Object ... args) {
        if (this.isWarnEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])args);
            this.log.log(null, callerFQCN, 30, ft.getMessage(), NULL_ARGS, ft.getThrowable());
        }
    }

    public void error(String format, Object ... args) {
        if (this.isErrorEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])args);
            JbootExceptionHolder.hold(ft.getMessage(), ft.getThrowable());
            this.log.log(null, callerFQCN, 40, ft.getMessage(), NULL_ARGS, ft.getThrowable());
        }
    }

    public void fatal(String format, Object ... args) {
        this.error(format, args);
    }
}

