/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.core.log;

import com.jfinal.log.Log;
import com.jfinal.log.Slf4jLogFactory;
import io.jboot.core.log.JdkLogger;
import io.jboot.core.log.Slf4jLogger;
import io.jboot.core.log.Slf4jSimpleLogger;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class JbootLogFactory
extends Slf4jLogFactory {
    private boolean useJdkLogger = false;

    public JbootLogFactory() {
        boolean hasStaticLoggerBinder = false;
        try {
            Class.forName("org.slf4j.impl.StaticLoggerBinder");
            hasStaticLoggerBinder = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!hasStaticLoggerBinder) {
            this.useJdkLogger = true;
        } else {
            ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
            if (loggerFactory.getClass() == NOPLoggerFactory.class) {
                this.useJdkLogger = true;
            } else {
                System.out.println("Jboot LoggerFactory: " + loggerFactory.getClass().getName());
            }
        }
    }

    public Log getLog(Class<?> clazz) {
        if (this.useJdkLogger) {
            return new JdkLogger(clazz);
        }
        Logger log = LoggerFactory.getLogger(clazz);
        return log instanceof LocationAwareLogger ? new Slf4jLogger((LocationAwareLogger)log) : new Slf4jSimpleLogger(log);
    }

    public Log getLog(String name) {
        if (this.useJdkLogger) {
            return new JdkLogger(name);
        }
        Logger log = LoggerFactory.getLogger((String)name);
        return log instanceof LocationAwareLogger ? new Slf4jLogger((LocationAwareLogger)log) : new Slf4jSimpleLogger(log);
    }
}

