/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.core.listener;

import com.jfinal.config.Constants;
import com.jfinal.config.Interceptors;
import com.jfinal.config.Routes;
import com.jfinal.log.Log;
import com.jfinal.template.Engine;
import io.jboot.aop.jfinal.JfinalHandlers;
import io.jboot.aop.jfinal.JfinalPlugins;
import io.jboot.app.JbootApplicationConfig;
import io.jboot.core.listener.JbootAppListener;
import io.jboot.core.listener.JbootAppListenerBase;
import io.jboot.core.weight.WeightUtil;
import io.jboot.utils.ClassScanner;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.StrUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JbootAppListenerManager
implements JbootAppListener {
    private static final Log LOG = Log.getLog(JbootAppListenerManager.class);
    private static JbootAppListenerManager me = new JbootAppListenerManager();
    private List<JbootAppListener> listeners = new ArrayList<JbootAppListener>();

    public static JbootAppListenerManager me() {
        return me;
    }

    private JbootAppListenerManager() {
        HashSet packages;
        String listener = JbootApplicationConfig.get().getListener();
        String listenerPackage = JbootApplicationConfig.get().getListenerPackage();
        Set<Object> set = packages = StrUtil.isNotBlank(listenerPackage) && !"*".equals(listenerPackage.trim()) ? StrUtil.splitToSet(listenerPackage, ";") : new HashSet();
        if (StrUtil.isBlank((String)listener) || "*".equals(listener.trim())) {
            List<Class<JbootAppListener>> allListeners = ClassScanner.scanSubClass(JbootAppListener.class, true);
            allListeners.removeIf(c -> c == JbootAppListenerManager.class || c == JbootAppListenerBase.class);
            allListeners.forEach(clazz -> {
                JbootAppListener appListener;
                if (this.isMatchedPackage(packages, clazz.getCanonicalName()) && (appListener = (JbootAppListener)ClassUtil.newInstance(clazz)) != null) {
                    this.listeners.add(appListener);
                }
            });
        } else {
            StrUtil.splitToSet(listener, ";").forEach(className -> {
                if (this.isMatchedPackage(packages, (String)className)) {
                    JbootAppListener appListener = (JbootAppListener)ClassUtil.newInstance(className);
                    if (appListener != null) {
                        this.listeners.add(appListener);
                    } else {
                        LOG.warn("Can not create JbootAppListener by class: " + className);
                    }
                }
            });
        }
        WeightUtil.sort(this.listeners);
    }

    private boolean isMatchedPackage(Set<String> packages, String className) {
        if (packages == null || packages.isEmpty()) {
            return true;
        }
        for (String packageString : packages) {
            if (!className.startsWith(packageString)) continue;
            return true;
        }
        return false;
    }

    public List<JbootAppListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void onInit() {
        for (JbootAppListener listener : this.listeners) {
            try {
                listener.onInit();
            }
            catch (Throwable ex) {
                LOG.error(ex.toString(), ex);
            }
        }
    }

    @Override
    public void onConstantConfigBefore(Constants constants) {
        for (JbootAppListener listener : this.listeners) {
            try {
                listener.onConstantConfigBefore(constants);
            }
            catch (Throwable ex) {
                LOG.error(ex.toString(), ex);
            }
        }
    }

    @Override
    public void onConstantConfig(Constants constants) {
        for (JbootAppListener listener : this.listeners) {
            try {
                listener.onConstantConfig(constants);
            }
            catch (Throwable ex) {
                LOG.error(ex.toString(), ex);
            }
        }
    }

    @Override
    public void onRouteConfig(Routes routes) {
        for (JbootAppListener listener : this.listeners) {
            try {
                listener.onRouteConfig(routes);
            }
            catch (Throwable ex) {
                LOG.error(ex.toString(), ex);
            }
        }
    }

    @Override
    public void onEngineConfig(Engine engine) {
        for (JbootAppListener listener : this.listeners) {
            try {
                listener.onEngineConfig(engine);
            }
            catch (Throwable ex) {
                LOG.error(ex.toString(), ex);
            }
        }
    }

    @Override
    public void onPluginConfig(JfinalPlugins plugins) {
        for (JbootAppListener listener : this.listeners) {
            try {
                listener.onPluginConfig(plugins);
            }
            catch (Throwable ex) {
                LOG.error(ex.toString(), ex);
            }
        }
    }

    @Override
    public void onInterceptorConfig(Interceptors interceptors) {
        for (JbootAppListener listener : this.listeners) {
            try {
                listener.onInterceptorConfig(interceptors);
            }
            catch (Throwable ex) {
                LOG.error(ex.toString(), ex);
            }
        }
    }

    @Override
    public void onHandlerConfig(JfinalHandlers handlers) {
        for (JbootAppListener listener : this.listeners) {
            try {
                listener.onHandlerConfig(handlers);
            }
            catch (Throwable ex) {
                LOG.error(ex.toString(), ex);
            }
        }
    }

    @Override
    public void onStartBefore() {
        for (JbootAppListener listener : this.listeners) {
            try {
                listener.onStartBefore();
            }
            catch (Throwable ex) {
                LOG.error(ex.toString(), ex);
            }
        }
    }

    @Override
    public void onStart() {
        for (JbootAppListener listener : this.listeners) {
            try {
                listener.onStart();
            }
            catch (Throwable ex) {
                LOG.error(ex.toString(), ex);
            }
        }
    }

    @Override
    public void onStartFinish() {
        for (JbootAppListener listener : this.listeners) {
            try {
                listener.onStartFinish();
            }
            catch (Throwable ex) {
                LOG.error(ex.toString(), ex);
            }
        }
    }

    @Override
    public void onStop() {
        for (JbootAppListener listener : this.listeners) {
            try {
                listener.onStop();
            }
            catch (Throwable ex) {
                LOG.error(ex.toString(), ex);
            }
        }
    }
}

