/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.core;

import com.jfinal.aop.Aop;
import com.jfinal.aop.AopFactory;
import com.jfinal.aop.AopManager;
import com.jfinal.captcha.ICaptchaCache;
import com.jfinal.config.Constants;
import com.jfinal.config.Handlers;
import com.jfinal.config.Interceptors;
import com.jfinal.config.JFinalConfig;
import com.jfinal.config.Plugins;
import com.jfinal.config.Routes;
import com.jfinal.core.ActionHandler;
import com.jfinal.core.Controller;
import com.jfinal.core.ControllerFactory;
import com.jfinal.core.Path;
import com.jfinal.core.converter.TypeConverter;
import com.jfinal.handler.Handler;
import com.jfinal.kit.Func;
import com.jfinal.kit.PathKit;
import com.jfinal.kit.PropKit;
import com.jfinal.log.ILogFactory;
import com.jfinal.plugin.IPlugin;
import com.jfinal.plugin.activerecord.ActiveRecordPlugin;
import com.jfinal.render.IRenderFactory;
import com.jfinal.template.Directive;
import com.jfinal.template.Engine;
import com.jfinal.token.ITokenCache;
import io.jboot.Jboot;
import io.jboot.aop.JbootAopFactory;
import io.jboot.aop.jfinal.JfinalHandlers;
import io.jboot.aop.jfinal.JfinalPlugins;
import io.jboot.app.ApplicationUtil;
import io.jboot.components.cache.support.JbootCaptchaCache;
import io.jboot.components.cache.support.JbootTokenCache;
import io.jboot.components.gateway.JbootGatewayHandler;
import io.jboot.components.gateway.JbootGatewayManager;
import io.jboot.components.limiter.LimiterManager;
import io.jboot.components.rpc.JbootrpcManager;
import io.jboot.components.schedule.JbootScheduleManager;
import io.jboot.core.listener.JbootAppListenerManager;
import io.jboot.core.log.JbootLogFactory;
import io.jboot.db.ArpManager;
import io.jboot.support.metric.JbootMetricConfig;
import io.jboot.support.metric.MetricServletHandler;
import io.jboot.support.metric.request.JbootRequestMetricHandler;
import io.jboot.support.seata.JbootSeataManager;
import io.jboot.support.sentinel.JbootSentinelManager;
import io.jboot.support.sentinel.SentinelConfig;
import io.jboot.support.sentinel.SentinelHandler;
import io.jboot.support.shiro.JbootShiroManager;
import io.jboot.support.swagger.JbootSwaggerConfig;
import io.jboot.support.swagger.JbootSwaggerController;
import io.jboot.support.swagger.JbootSwaggerManager;
import io.jboot.utils.AnnotationUtil;
import io.jboot.utils.ArrayUtil;
import io.jboot.utils.ClassScanner;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.DateUtil;
import io.jboot.utils.ReflectUtil;
import io.jboot.utils.StrUtil;
import io.jboot.web.JbootActionMapping;
import io.jboot.web.JbootWebConfig;
import io.jboot.web.PathVariableActionMapping;
import io.jboot.web.TypeConverterFunc;
import io.jboot.web.attachment.AttachmentHandler;
import io.jboot.web.attachment.LocalAttachmentContainerConfig;
import io.jboot.web.controller.JbootControllerManager;
import io.jboot.web.controller.annotation.GetMapping;
import io.jboot.web.controller.annotation.PostMapping;
import io.jboot.web.controller.annotation.RequestMapping;
import io.jboot.web.directive.SharedEnumObject;
import io.jboot.web.directive.annotation.JFinalDirective;
import io.jboot.web.directive.annotation.JFinalSharedEnum;
import io.jboot.web.directive.annotation.JFinalSharedMethod;
import io.jboot.web.directive.annotation.JFinalSharedObject;
import io.jboot.web.directive.annotation.JFinalSharedStaticMethod;
import io.jboot.web.handler.JbootActionHandler;
import io.jboot.web.handler.JbootHandler;
import io.jboot.web.handler.PathVariableActionHandler;
import io.jboot.web.json.JbootJson;
import io.jboot.web.render.JbootRenderFactory;
import io.jboot.web.xss.XSSHandler;
import io.jboot.wechat.WechatSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class JbootCoreConfig
extends JFinalConfig {
    private List<Routes.Route> routeList = new ArrayList<Routes.Route>();

    public JbootCoreConfig() {
        this.initSystemProperties();
        AopManager.me().setInjectDependency(true);
        AopManager.me().setAopFactory((AopFactory)JbootAopFactory.me());
        Aop.inject((Object)((Object)this));
        this.initWebRootPath();
        JbootAppListenerManager.me().onInit();
    }

    private void initSystemProperties() {
        Properties properties;
        File spf = new File(PathKit.getRootClassPath(), "jboot-system.properties");
        if (spf.exists() && spf.isFile() && (properties = PropKit.use((File)spf).getProperties()) != null && !properties.isEmpty()) {
            for (Object key : properties.keySet()) {
                String newValue;
                String newKey;
                String systemValue;
                if (!StrUtil.isNotBlank(key) || StrUtil.isNotBlank(systemValue = System.getProperty(newKey = key.toString().trim())) || !StrUtil.isNotBlank(newValue = properties.getProperty(newKey))) continue;
                System.setProperty(newKey, newValue.trim());
            }
        }
    }

    private void initWebRootPath() {
        String webRootPath = (String)ReflectUtil.getStaticFieldValue(PathKit.class, "webRootPath");
        if (webRootPath == null) {
            PathKit.setWebRootPath((String)PathKit.getRootClassPath());
        }
    }

    public void configConstant(Constants constants) {
        JbootAppListenerManager.me().onConstantConfigBefore(constants);
        constants.setRenderFactory((IRenderFactory)JbootRenderFactory.me());
        constants.setDevMode(Jboot.isDevMode());
        constants.setLogFactory((ILogFactory)new JbootLogFactory());
        constants.setMaxPostSize(0x7D000000L);
        constants.setReportAfterInvocation(false);
        constants.setControllerFactory((ControllerFactory)JbootControllerManager.me());
        constants.setJsonFactory(JbootJson::new);
        constants.setInjectDependency(true);
        constants.setTokenCache((ITokenCache)new JbootTokenCache());
        constants.setCaptchaCache((ICaptchaCache)new JbootCaptchaCache());
        constants.setBaseUploadPath(LocalAttachmentContainerConfig.getInstance().buildUploadAbsolutePath());
        constants.setJsonDatePattern(DateUtil.datetimePattern);
        if (JbootWebConfig.getInstance().isPathVariableEnable()) {
            constants.setActionMapping(PathVariableActionMapping::new);
        } else {
            constants.setActionMapping(JbootActionMapping::new);
        }
        JbootAppListenerManager.me().onConstantConfig(constants);
    }

    public void configRoute(Routes routes) {
        JbootSwaggerConfig swaggerConfig;
        routes.setMappingSuperClass(true);
        List<Class<Controller>> controllerClassList = ClassScanner.scanSubClass(Controller.class);
        if (ArrayUtil.isNotEmpty(controllerClassList)) {
            for (Class<Controller> clazz : controllerClassList) {
                String[] valueAndViewPath = JbootCoreConfig.getMappingAndViewPath(clazz);
                if (valueAndViewPath == null) continue;
                this.initRoutes(routes, clazz, valueAndViewPath[0], valueAndViewPath[1]);
            }
        }
        if ((swaggerConfig = Jboot.config(JbootSwaggerConfig.class)).isConfigOk()) {
            routes.add(swaggerConfig.getPath(), JbootSwaggerController.class, swaggerConfig.getPath());
        }
        JbootAppListenerManager.me().onRouteConfig(routes);
        for (Routes.Route route : routes.getRouteItemList()) {
            JbootControllerManager.me().setMapping(route.getControllerPath(), route.getControllerClass());
        }
        this.routeList.addAll(routes.getRouteItemList());
    }

    private String removeLastSlash(String path) {
        while (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String[] getMappingAndViewPath(Class<? extends Controller> clazz) {
        RequestMapping rm = clazz.getAnnotation(RequestMapping.class);
        if (rm != null) {
            return new String[]{AnnotationUtil.get(rm.value()), AnnotationUtil.get(rm.viewPath())};
        }
        Path path = clazz.getAnnotation(Path.class);
        if (path != null) {
            return new String[]{AnnotationUtil.get(path.value()), AnnotationUtil.get(path.viewPath())};
        }
        GetMapping gp = clazz.getAnnotation(GetMapping.class);
        if (gp != null) {
            return new String[]{AnnotationUtil.get(gp.value()), AnnotationUtil.get(gp.viewPath())};
        }
        PostMapping pp = clazz.getAnnotation(PostMapping.class);
        if (pp != null) {
            return new String[]{AnnotationUtil.get(pp.value()), AnnotationUtil.get(pp.viewPath())};
        }
        return null;
    }

    private void initRoutes(Routes routes, Class<Controller> controllerClass, String path, String viewPath) {
        if (StrUtil.isBlank((String)path)) {
            return;
        }
        path = AnnotationUtil.get(path);
        path = this.removeLastSlash(path);
        if ("*".equals(viewPath = AnnotationUtil.get(viewPath))) {
            routes.add(path, controllerClass);
        } else {
            routes.add(path, controllerClass, viewPath);
        }
    }

    public void configEngine(Engine engine) {
        if (ApplicationUtil.runInFatjar()) {
            engine.setToClassPathSourceFactory();
            engine.setBaseTemplatePath("webapp");
        }
        List<Class> directiveClasses = ClassScanner.scanClass();
        for (Class clazz : directiveClasses) {
            JFinalSharedObject sharedObject;
            JFinalSharedStaticMethod sharedStaticMethod;
            JFinalSharedEnum sharedEnum;
            String name;
            if (Directive.class.isAssignableFrom(clazz)) {
                JFinalDirective directive = clazz.getAnnotation(JFinalDirective.class);
                if (directive != null) {
                    name = AnnotationUtil.get(directive.value());
                    if (directive.override()) {
                        engine.removeDirective(name);
                    }
                    engine.addDirective(name, clazz);
                }
            } else if (clazz.isEnum() && (sharedEnum = clazz.getAnnotation(JFinalSharedEnum.class)) != null) {
                name = AnnotationUtil.get(sharedEnum.value(), clazz.getSimpleName());
                if (sharedEnum.override()) {
                    engine.removeSharedObject(name);
                }
                engine.addSharedObject(name, (Object)SharedEnumObject.create(clazz));
            }
            JFinalSharedMethod sharedMethod = clazz.getAnnotation(JFinalSharedMethod.class);
            if (sharedMethod != null) {
                engine.addSharedMethod(ClassUtil.newInstance(clazz));
            }
            if ((sharedStaticMethod = clazz.getAnnotation(JFinalSharedStaticMethod.class)) != null) {
                engine.addSharedStaticMethod(clazz);
            }
            if ((sharedObject = clazz.getAnnotation(JFinalSharedObject.class)) == null) continue;
            engine.addSharedObject(AnnotationUtil.get(sharedObject.value()), ClassUtil.newInstance(clazz));
        }
        JbootAppListenerManager.me().onEngineConfig(engine);
    }

    public void configPlugin(Plugins plugins) {
        List<ActiveRecordPlugin> arps = ArpManager.me().getActiveRecordPlugins();
        for (ActiveRecordPlugin arp : arps) {
            plugins.add((IPlugin)arp);
        }
        JbootAppListenerManager.me().onPluginConfig(new JfinalPlugins(plugins));
    }

    public void configInterceptor(Interceptors interceptors) {
        JbootAppListenerManager.me().onInterceptorConfig(interceptors);
    }

    public void configHandler(Handlers handlers) {
        JbootMetricConfig metricsConfig;
        JbootAppListenerManager.me().onHandlerConfig(new JfinalHandlers(handlers));
        if (JbootGatewayManager.me().isConfigOk()) {
            handlers.add((Handler)new JbootGatewayHandler());
        }
        handlers.add((Handler)new AttachmentHandler());
        SentinelConfig sentinelConfig = SentinelConfig.get();
        if (sentinelConfig.isEnable() && sentinelConfig.isReqeustEnable()) {
            handlers.add((Handler)new SentinelHandler());
        }
        if ((metricsConfig = Jboot.config(JbootMetricConfig.class)).isEnable() && metricsConfig.isConfigOk()) {
            if (StrUtil.isNotBlank(metricsConfig.getAdminServletMapping())) {
                handlers.add((Handler)new MetricServletHandler(metricsConfig.getAdminServletMapping()));
            }
            if (metricsConfig.isRequestMetricEnable()) {
                handlers.add((Handler)new JbootRequestMetricHandler());
            }
        }
        if (JbootWebConfig.getInstance().isEscapeParasEnable()) {
            handlers.add((Handler)new XSSHandler());
        }
        handlers.add((Handler)new JbootHandler());
        if (handlers.getActionHandler() == null) {
            if (JbootWebConfig.getInstance().isPathVariableEnable()) {
                handlers.setActionHandler((ActionHandler)new PathVariableActionHandler());
            } else {
                handlers.setActionHandler((ActionHandler)new JbootActionHandler());
            }
        }
    }

    public void onStart() {
        JbootAppListenerManager.me().onStartBefore();
        JbootrpcManager.me().init();
        JbootShiroManager.me().init(this.routeList);
        JbootScheduleManager.me().init();
        JbootSwaggerManager.me().init();
        LimiterManager.me().init();
        JbootSeataManager.me().init();
        JbootSentinelManager.me().init();
        if (ClassUtil.hasClass("com.jfinal.weixin.sdk.api.ApiConfigKit")) {
            new WechatSupport().autoSupport();
        }
        JbootAppListenerManager.me().onStart();
        TypeConverter.me().setConvertFunc((Func.F21)new TypeConverterFunc());
        JbootAppListenerManager.me().onStartFinish();
    }

    public void onStop() {
        JbootAppListenerManager.me().onStop();
        JbootScheduleManager.me().stop();
        JbootSeataManager.me().stop();
        JbootrpcManager.me().stop();
    }
}

