/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.valid.interceptor;

import io.jboot.aop.InterceptorBuilder;
import io.jboot.aop.Interceptors;
import io.jboot.aop.annotation.AutoLoad;
import io.jboot.components.valid.interceptor.DecimalMaxInterceptor;
import io.jboot.components.valid.interceptor.DecimalMinInterceptor;
import io.jboot.components.valid.interceptor.DigitsInterceptor;
import io.jboot.components.valid.interceptor.EmailInterceptor;
import io.jboot.components.valid.interceptor.MaxInterceptor;
import io.jboot.components.valid.interceptor.MinInterceptor;
import io.jboot.components.valid.interceptor.NegativeInterceptor;
import io.jboot.components.valid.interceptor.NegativeOrZeroInterceptor;
import io.jboot.components.valid.interceptor.NotBlankInterceptor;
import io.jboot.components.valid.interceptor.NotEmptyInterceptor;
import io.jboot.components.valid.interceptor.NotNullInterceptor;
import io.jboot.components.valid.interceptor.PatternInterceptor;
import io.jboot.components.valid.interceptor.PositiveInterceptor;
import io.jboot.components.valid.interceptor.PositiveOrZeroInterceptor;
import io.jboot.components.valid.interceptor.SizeInterceptor;
import io.jboot.components.valid.interceptor.ValidInterceptor;
import io.jboot.core.weight.Weight;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Email;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Negative;
import javax.validation.constraints.NegativeOrZero;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Positive;
import javax.validation.constraints.PositiveOrZero;
import javax.validation.constraints.Size;

@AutoLoad
@Weight(value=100)
public class ValidInterceptorBuilder
implements InterceptorBuilder {
    @Override
    public void build(Class<?> targetClass, Method method, Interceptors interceptors) {
        Parameter[] parameters = method.getParameters();
        if (parameters != null && parameters.length > 0) {
            for (Parameter p : parameters) {
                if (p.getAnnotation(DecimalMax.class) != null) {
                    interceptors.addIfNotExist(DecimalMaxInterceptor.class);
                }
                if (p.getAnnotation(DecimalMin.class) != null) {
                    interceptors.addIfNotExist(DecimalMinInterceptor.class);
                }
                if (p.getAnnotation(Digits.class) != null) {
                    interceptors.addIfNotExist(DigitsInterceptor.class);
                }
                if (p.getAnnotation(Email.class) != null) {
                    interceptors.addIfNotExist(EmailInterceptor.class);
                }
                if (p.getAnnotation(Max.class) != null) {
                    interceptors.addIfNotExist(MaxInterceptor.class);
                }
                if (p.getAnnotation(Min.class) != null) {
                    interceptors.addIfNotExist(MinInterceptor.class);
                }
                if (p.getAnnotation(Negative.class) != null) {
                    interceptors.addIfNotExist(NegativeInterceptor.class);
                }
                if (p.getAnnotation(NegativeOrZero.class) != null) {
                    interceptors.addIfNotExist(NegativeOrZeroInterceptor.class);
                }
                if (p.getAnnotation(NotBlank.class) != null) {
                    interceptors.addIfNotExist(NotBlankInterceptor.class);
                }
                if (p.getAnnotation(NotEmpty.class) != null) {
                    interceptors.addIfNotExist(NotEmptyInterceptor.class);
                }
                if (p.getAnnotation(NotNull.class) != null) {
                    interceptors.addIfNotExist(NotNullInterceptor.class);
                }
                if (p.getAnnotation(Pattern.class) != null) {
                    interceptors.addIfNotExist(PatternInterceptor.class);
                }
                if (p.getAnnotation(Positive.class) != null) {
                    interceptors.addIfNotExist(PositiveInterceptor.class);
                }
                if (p.getAnnotation(PositiveOrZero.class) != null) {
                    interceptors.addIfNotExist(PositiveOrZeroInterceptor.class);
                }
                if (p.getAnnotation(Size.class) != null) {
                    interceptors.addIfNotExist(SizeInterceptor.class);
                }
                if (p.getAnnotation(Valid.class) == null) continue;
                interceptors.addIfNotExist(ValidInterceptor.class);
            }
        }
    }
}

