/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.valid.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import io.jboot.components.valid.ValidUtil;
import io.jboot.utils.ClassUtil;
import java.lang.reflect.Parameter;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Valid;

public class ValidInterceptor
implements Interceptor {
    public void intercept(Invocation inv) {
        Parameter[] parameters = inv.getMethod().getParameters();
        for (int index = 0; index < parameters.length; ++index) {
            Set<ConstraintViolation<Object>> constraintViolations;
            Object validObject;
            if (parameters[index].getAnnotation(Valid.class) == null || (validObject = inv.getArg(index)) == null || (constraintViolations = ValidUtil.validate(validObject)) == null || constraintViolations.size() <= 0) continue;
            StringBuilder msg = new StringBuilder();
            for (ConstraintViolation<Object> cv : constraintViolations) {
                msg.append(cv.getRootBeanClass().getName()).append(".").append(cv.getPropertyPath()).append(cv.getMessage());
            }
            String reason = parameters[index].getName() + " is valid failed at method: " + ClassUtil.buildMethodString(inv.getMethod());
            ValidUtil.throwValidException(parameters[index].getName(), msg.toString(), reason);
        }
        inv.invoke();
    }
}

