/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.valid.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.kit.Ret;
import io.jboot.components.valid.ValidUtil;
import io.jboot.utils.ClassUtil;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.Map;
import javax.validation.constraints.Size;

public class SizeInterceptor
implements Interceptor {
    public void intercept(Invocation inv) {
        Parameter[] parameters = inv.getMethod().getParameters();
        for (int index = 0; index < parameters.length; ++index) {
            Size size = parameters[index].getAnnotation(Size.class);
            if (size == null) continue;
            Object validObject = inv.getArg(index);
            if (validObject == null) {
                String reason = parameters[index].getName() + " need size is " + size.min() + " ~ " + size.max() + ", but current value is null at method: " + ClassUtil.buildMethodString(inv.getMethod());
                Ret paras = Ret.by((Object)"max", (Object)size.max()).set((Object)"min", (Object)size.min());
                ValidUtil.throwValidException(parameters[index].getName(), size.message(), paras, reason);
                return;
            }
            int len = this.getObjectLen(validObject);
            if (len >= size.min() && len <= size.max()) continue;
            String reason = parameters[index].getName() + " need size is " + size.min() + " ~ " + size.max() + ", but current value size (or length) is " + len + " at method: " + ClassUtil.buildMethodString(inv.getMethod());
            Ret paras = Ret.by((Object)"max", (Object)size.max()).set((Object)"min", (Object)size.min());
            ValidUtil.throwValidException(parameters[index].getName(), size.message(), paras, reason);
        }
        inv.invoke();
    }

    private int getObjectLen(Object validObject) {
        if (validObject instanceof Number) {
            return ((Number)validObject).intValue();
        }
        if (validObject instanceof CharSequence) {
            return ((CharSequence)validObject).length();
        }
        if (validObject instanceof Map) {
            return ((Map)validObject).size();
        }
        if (validObject instanceof Collection) {
            return ((Collection)validObject).size();
        }
        if (validObject.getClass().isArray()) {
            return ((Object[])validObject).length;
        }
        return -1;
    }
}

