/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.valid.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.kit.Ret;
import io.jboot.components.valid.ValidUtil;
import io.jboot.utils.ClassUtil;
import java.lang.reflect.Parameter;
import javax.validation.constraints.Pattern;

public class PatternInterceptor
implements Interceptor {
    public void intercept(Invocation inv) {
        Parameter[] parameters = inv.getMethod().getParameters();
        for (int index = 0; index < parameters.length; ++index) {
            Object validObject;
            Pattern pattern = parameters[index].getAnnotation(Pattern.class);
            if (pattern == null || (validObject = inv.getArg(index)) != null && PatternInterceptor.matches(pattern, validObject.toString())) continue;
            String reason = parameters[index].getName() + " is null or not matches the regex at method: " + ClassUtil.buildMethodString(inv.getMethod());
            Ret paras = Ret.by((Object)"regexp", (Object)pattern.regexp());
            ValidUtil.throwValidException(parameters[index].getName(), pattern.message(), paras, reason);
        }
        inv.invoke();
    }

    private static boolean matches(Pattern pattern, String value) {
        Pattern.Flag[] flags = pattern.flags();
        if (flags.length == 0) {
            return value.matches(pattern.regexp());
        }
        int intFlag = 0;
        for (Pattern.Flag flag : flags) {
            intFlag |= flag.getValue();
        }
        java.util.regex.Pattern p = java.util.regex.Pattern.compile(pattern.regexp(), intFlag);
        return p.matcher(value).matches();
    }
}

