/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.valid.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import io.jboot.components.valid.ValidUtil;
import io.jboot.utils.ClassUtil;
import java.lang.reflect.Parameter;
import java.util.regex.Pattern;
import javax.validation.constraints.Email;
import javax.validation.constraints.Pattern;

public class EmailInterceptor
implements Interceptor {
    public void intercept(Invocation inv) {
        Parameter[] parameters = inv.getMethod().getParameters();
        for (int index = 0; index < parameters.length; ++index) {
            Object validObject;
            Email email = parameters[index].getAnnotation(Email.class);
            if (email == null || (validObject = inv.getArg(index)) != null && EmailInterceptor.matches(email, validObject.toString())) continue;
            String reason = parameters[index].getName() + " is not email at method: " + ClassUtil.buildMethodString(inv.getMethod());
            ValidUtil.throwValidException(parameters[index].getName(), email.message(), reason);
        }
        inv.invoke();
    }

    private static boolean matches(Email email, String value) {
        String regexp;
        Pattern.Flag[] flags = email.flags();
        String string = regexp = ".*".equals(email.regexp()) ? "^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$" : email.regexp();
        if (flags.length == 0) {
            return value.matches(regexp);
        }
        int intFlag = 0;
        for (Pattern.Flag flag : flags) {
            intFlag |= flag.getValue();
        }
        Pattern p = Pattern.compile(regexp, intFlag);
        return p.matcher(value).matches();
    }
}

