/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.valid.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.kit.Ret;
import io.jboot.components.valid.ValidUtil;
import io.jboot.utils.ClassUtil;
import java.lang.reflect.Parameter;
import javax.validation.constraints.Digits;

public class DigitsInterceptor
implements Interceptor {
    public void intercept(Invocation inv) {
        Parameter[] parameters = inv.getMethod().getParameters();
        for (int index = 0; index < parameters.length; ++index) {
            Object validObject;
            Digits digits = parameters[index].getAnnotation(Digits.class);
            if (digits == null || (validObject = inv.getArg(index)) == null || this.matchesDigits(digits, validObject)) continue;
            String reason = parameters[index].getName() + " not matches @Digits at method: " + ClassUtil.buildMethodString(inv.getMethod());
            Ret paras = Ret.by((Object)"integer", (Object)digits.integer()).set((Object)"fraction", (Object)digits.fraction());
            ValidUtil.throwValidException(parameters[index].getName(), digits.message(), paras, reason);
        }
        inv.invoke();
    }

    private boolean matchesDigits(Digits digits, Object validObject) {
        String validString = validObject.toString();
        String[] valids = validString.split("\\.");
        int integer = this.removeStartZero(valids[0]).length();
        int fraction = valids[0].length() == 1 ? 0 : this.removeEndZero(valids[1]).length();
        return integer <= digits.integer() && fraction <= digits.fraction();
    }

    private String removeStartZero(String string) {
        while (string.startsWith("0")) {
            string = string.substring(1);
        }
        return string;
    }

    private String removeEndZero(String string) {
        while (string.endsWith("0")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }
}

