/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.valid.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.kit.Ret;
import io.jboot.components.valid.ValidUtil;
import io.jboot.utils.ClassUtil;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.validation.constraints.DecimalMax;

public class DecimalMaxInterceptor
implements Interceptor {
    public void intercept(Invocation inv) {
        Parameter[] parameters = inv.getMethod().getParameters();
        for (int index = 0; index < parameters.length; ++index) {
            Object validObject;
            DecimalMax decimalMax = parameters[index].getAnnotation(DecimalMax.class);
            if (decimalMax == null || (validObject = inv.getArg(index)) == null || this.matches(decimalMax, validObject)) continue;
            String reason = parameters[index].getName() + " max value is " + decimalMax.value() + ", but current value is " + validObject + " at method: " + ClassUtil.buildMethodString(inv.getMethod());
            Ret paras = Ret.by((Object)"value", (Object)decimalMax.value());
            ValidUtil.throwValidException(parameters[index].getName(), decimalMax.message(), paras, reason);
        }
        inv.invoke();
    }

    private boolean matches(DecimalMax decimalMax, Object validObject) {
        if (validObject instanceof BigInteger) {
            return ((BigInteger)validObject).compareTo(new BigInteger(decimalMax.value())) <= 0;
        }
        if (validObject instanceof BigDecimal) {
            return ((BigDecimal)validObject).compareTo(new BigDecimal(decimalMax.value())) <= 0;
        }
        if (validObject instanceof CharSequence) {
            return new BigDecimal(validObject.toString()).compareTo(new BigDecimal(decimalMax.value())) <= 0;
        }
        if (validObject instanceof Float) {
            return ((Float)validObject).floatValue() <= Float.parseFloat(decimalMax.value());
        }
        if (validObject instanceof Double) {
            return (Double)validObject <= Double.parseDouble(decimalMax.value());
        }
        if (validObject instanceof Number) {
            return ((Number)validObject).longValue() <= Long.parseLong(decimalMax.value());
        }
        return false;
    }
}

