/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.valid;

import com.jfinal.kit.Ret;
import io.jboot.components.valid.ValidException;
import io.jboot.components.valid.interceptor.SimpleContext;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;

public class ValidUtil {
    private static ValidatorFactory validatorFactory = ((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(true).buildValidatorFactory();
    private static Validator validator = validatorFactory.getValidator();
    private static MessageInterpolator messageInterpolator = validatorFactory.getMessageInterpolator();
    private static int errorCode = 400;

    public static Validator getValidator() {
        return validator;
    }

    public static void setValidator(Validator validator) {
        ValidUtil.validator = validator;
    }

    public static int getErrorCode() {
        return errorCode;
    }

    public static void setErrorCode(int errorCode) {
        ValidUtil.errorCode = errorCode;
    }

    public static Set<ConstraintViolation<Object>> validate(Object object) {
        return validator.validate(object, new Class[0]);
    }

    public static void throwValidException(String fieldName, String message, String reason) {
        ValidUtil.throwValidException(fieldName, message, null, reason);
    }

    public static void throwValidException(String fieldName, String message, Ret paras, String reason) {
        if (ValidUtil.isParaMessage(message)) {
            message = fieldName + " " + messageInterpolator.interpolate(message, (MessageInterpolator.Context)new SimpleContext(paras));
        }
        throw new ValidException(message, reason, fieldName);
    }

    private static boolean isParaMessage(String message) {
        return message != null && message.startsWith("{") && message.endsWith("}");
    }
}

