/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.valid;

import com.jfinal.kit.JsonKit;
import com.jfinal.kit.Ret;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import io.jboot.components.valid.ValidException;
import io.jboot.components.valid.ValidUtil;
import io.jboot.utils.RequestUtil;

public class ValidErrorRender
extends Render {
    protected static final String htmlContentType = "text/html;charset=" + ValidErrorRender.getEncoding();
    protected static final String jsonContentType = "application/json;charset=" + ValidErrorRender.getEncoding();
    protected static final String html_header = "<html><head><title>Parameter Valid Error</title></head><body bgcolor='white'><center><h1>Parameter Valid Error</h1></center><hr>";
    protected static final String poweredBy = "<center><a href='http://jboot.io' target='_blank'><b>Powered by Jboot</b></a></center>";
    protected static final String html_footer = "<hr><center><a href='http://jboot.io' target='_blank'><b>Powered by Jboot</b></a></center></body></html>";
    protected int errorCode = ValidUtil.getErrorCode();
    protected final ValidException validException;

    public ValidErrorRender(ValidException validException) {
        this.validException = validException;
    }

    public void render() {
        try {
            if (RequestUtil.isJsonContentType(this.request) || RequestUtil.isAjaxRequest(this.request)) {
                this.response.setStatus(200);
                this.response.setContentType(jsonContentType);
                this.response.getWriter().write(this.getErrorJson());
            } else {
                this.response.setStatus(this.errorCode);
                this.response.setContentType(htmlContentType);
                this.response.getWriter().write(this.getErrorHtml());
            }
        }
        catch (Exception ex) {
            throw new RenderException((Throwable)ex);
        }
    }

    public String getErrorHtml() {
        StringBuilder html = new StringBuilder(html_header);
        html.append(this.validException.getFormName() == null ? "" : this.validException.getFormName() + ": ");
        html.append(this.validException.getMessage()).append("<br />");
        return html.append(html_footer).toString();
    }

    public String getErrorJson() {
        Ret ret = Ret.fail().set((Object)"errorCode", (Object)this.errorCode);
        ret.set((Object)"throwable", (Object)(this.validException.getClass().getName() + ": " + this.validException.getMessage()));
        ret.set((Object)"message", (Object)this.validException.getMessage());
        ret.set((Object)"errorMessage", (Object)this.validException.getReason());
        ret.set((Object)"formName", (Object)this.validException.getFormName());
        return JsonKit.toJson((Object)ret);
    }
}

