/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.serializer;

import io.jboot.Jboot;
import io.jboot.components.serializer.FastJsonSerializer;
import io.jboot.components.serializer.FstSerializer;
import io.jboot.components.serializer.JbootSerializer;
import io.jboot.components.serializer.JbootSerializerConfig;
import io.jboot.components.serializer.KryoSerializer;
import io.jboot.core.spi.JbootSpiLoader;
import io.jboot.exception.JbootIllegalConfigException;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.StrUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JbootSerializerManager {
    private static JbootSerializerManager me;
    private static Map<String, JbootSerializer> serializerCaches;

    public static JbootSerializerManager me() {
        if (me == null) {
            me = ClassUtil.singleton(JbootSerializerManager.class);
        }
        return me;
    }

    public JbootSerializer getSerializer() {
        JbootSerializerConfig config = Jboot.config(JbootSerializerConfig.class);
        if (StrUtil.isBlank((String)config.getType())) {
            throw new JbootIllegalConfigException("can not get serializer config, please set jboot.serializer value to jboot.proerties");
        }
        return this.getSerializer(config.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JbootSerializer getSerializer(String serializerName) {
        JbootSerializer serializer = serializerCaches.get(serializerName);
        if (serializer == null) {
            JbootSerializerManager jbootSerializerManager = this;
            synchronized (jbootSerializerManager) {
                serializer = serializerCaches.get(serializerName);
                if (serializer == null) {
                    serializer = this.buildSerializer(serializerName);
                    serializerCaches.put(serializerName, serializer);
                }
            }
        }
        return serializer;
    }

    public JbootSerializer buildSerializer(String serializerName) {
        if (serializerName == null) {
            throw new NullPointerException("SerializerName must not be null");
        }
        switch (serializerName.toLowerCase()) {
            case "kryo": {
                return new KryoSerializer();
            }
            case "fst": {
                return new FstSerializer();
            }
            case "fastjson": {
                return new FastJsonSerializer();
            }
        }
        return JbootSpiLoader.load(JbootSerializer.class, serializerName);
    }

    static {
        serializerCaches = new ConcurrentHashMap<String, JbootSerializer>();
    }
}

