/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.serializer;

import com.jfinal.log.Log;
import io.jboot.components.serializer.JbootSerializer;
import org.nustaq.serialization.FSTConfiguration;

public class FstSerializer
implements JbootSerializer {
    private static final Log LOG = Log.getLog(FstSerializer.class);
    private static FSTConfiguration fst = FSTConfiguration.createDefaultConfiguration();

    @Override
    public byte[] serialize(Object obj) {
        if (obj == null) {
            return null;
        }
        return fst.asByteArray(obj);
    }

    @Override
    public Object deserialize(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            return fst.asObject(bytes);
        }
        catch (Exception ex) {
            LOG.error("FstSerializer deserialize fail!", (Throwable)ex);
            return null;
        }
    }
}

