/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.IOUtils;
import com.jfinal.log.Log;
import io.jboot.components.serializer.JbootSerializer;

public class FastJsonSerializer
implements JbootSerializer {
    private static final Log LOG = Log.getLog(FastJsonSerializer.class);
    private static final ParserConfig autoTypeSupportConfig = new ParserConfig();

    @Override
    public byte[] serialize(Object obj) {
        if (obj == null) {
            return null;
        }
        return JSON.toJSONBytes((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName, SerializerFeature.SkipTransientField, SerializerFeature.IgnoreErrorGetter});
    }

    @Override
    public Object deserialize(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            return JSON.parse((String)new String(bytes, IOUtils.UTF8), (ParserConfig)autoTypeSupportConfig);
        }
        catch (Exception e) {
            LOG.error(e.toString(), (Throwable)e);
            return null;
        }
    }

    static {
        autoTypeSupportConfig.setAutoTypeSupport(true);
    }
}

