/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.schedule;

import com.jfinal.kit.PathKit;
import com.jfinal.kit.Prop;
import com.jfinal.log.Log;
import io.jboot.Jboot;
import io.jboot.components.schedule.JbooScheduleConfig;
import io.jboot.components.schedule.JbootCron4jPlugin;
import io.jboot.components.schedule.JbootDistributedRunnable;
import io.jboot.components.schedule.JbootSafeRunnable;
import io.jboot.components.schedule.annotation.Cron;
import io.jboot.components.schedule.annotation.EnableDistributedRunnable;
import io.jboot.components.schedule.annotation.FixedDelay;
import io.jboot.components.schedule.annotation.FixedRate;
import io.jboot.utils.AnnotationUtil;
import io.jboot.utils.ClassScanner;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.NamedThreadFactory;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class JbootScheduleManager {
    private static final Log LOG = Log.getLog(JbootScheduleManager.class);
    private static JbootScheduleManager manager = new JbootScheduleManager();
    private JbootCron4jPlugin cron4jPlugin;
    private ScheduledThreadPoolExecutor fixedScheduler;
    private JbooScheduleConfig config;
    private Map<Class<?>, Runnable> scheduleRunnableCache = new ConcurrentHashMap();
    private Map<Class<?>, ScheduledFuture<?>> scheduleFutureCache = new ConcurrentHashMap();

    public JbootScheduleManager() {
        this.config = Jboot.config(JbooScheduleConfig.class);
        this.fixedScheduler = new ScheduledThreadPoolExecutor(this.config.getPoolSize(), new NamedThreadFactory("jboot-scheduler"));
        File cron4jProperties = new File(PathKit.getRootClassPath(), this.config.getCron4jFile());
        this.cron4jPlugin = cron4jProperties.exists() ? new JbootCron4jPlugin(new Prop(this.config.getCron4jFile())) : new JbootCron4jPlugin();
    }

    public static final JbootScheduleManager me() {
        return manager;
    }

    public void init() {
        this.initSchedules();
        this.cron4jPlugin.start();
    }

    public void stop() {
        this.fixedScheduler.shutdownNow();
        this.cron4jPlugin.stop();
    }

    private void initSchedules() {
        List<Class<Runnable>> runnableClass = ClassScanner.scanSubClass(Runnable.class, true);
        runnableClass.forEach(this::addSchedule);
    }

    public void addSchedule(Class<? extends Runnable> runnableClass) {
        Cron cron;
        FixedRate fixedRateJob;
        FixedDelay fixedDelayJob = runnableClass.getAnnotation(FixedDelay.class);
        if (fixedDelayJob != null) {
            Runnable runnable = ClassUtil.newInstance(runnableClass);
            EnableDistributedRunnable enableDistributedRunnable = runnableClass.getAnnotation(EnableDistributedRunnable.class);
            Runnable executeRunnable = enableDistributedRunnable == null ? runnable : new JbootDistributedRunnable(runnable, AnnotationUtil.get(enableDistributedRunnable.redisKey()), enableDistributedRunnable.expireSeconds());
            executeRunnable = new JbootSafeRunnable(executeRunnable);
            try {
                this.scheduleRunnableCache.put(runnableClass, executeRunnable);
                ScheduledFuture<?> sf = this.fixedScheduler.scheduleWithFixedDelay(executeRunnable, fixedDelayJob.initialDelay(), fixedDelayJob.period(), TimeUnit.SECONDS);
                this.scheduleFutureCache.put(runnableClass, sf);
            }
            catch (Exception e) {
                LOG.error(e.toString(), (Throwable)e);
            }
        }
        if ((fixedRateJob = runnableClass.getAnnotation(FixedRate.class)) != null) {
            Runnable runnable = ClassUtil.newInstance(runnableClass);
            EnableDistributedRunnable enableDistributedRunnable = runnableClass.getAnnotation(EnableDistributedRunnable.class);
            Runnable executeRunnable = enableDistributedRunnable == null ? runnable : new JbootDistributedRunnable(runnable, AnnotationUtil.get(enableDistributedRunnable.redisKey()), enableDistributedRunnable.expireSeconds());
            executeRunnable = new JbootSafeRunnable(executeRunnable);
            try {
                this.scheduleRunnableCache.put(runnableClass, executeRunnable);
                ScheduledFuture<?> future = this.fixedScheduler.scheduleAtFixedRate(executeRunnable, fixedRateJob.initialDelay(), fixedRateJob.period(), TimeUnit.SECONDS);
                this.scheduleFutureCache.put(runnableClass, future);
            }
            catch (Exception e) {
                LOG.error(e.toString(), (Throwable)e);
            }
        }
        if ((cron = runnableClass.getAnnotation(Cron.class)) != null) {
            String value = AnnotationUtil.get(cron.value());
            Runnable runnable = ClassUtil.newInstance(runnableClass);
            EnableDistributedRunnable enableDistributedRunnable = runnableClass.getAnnotation(EnableDistributedRunnable.class);
            Runnable executeRunnable = enableDistributedRunnable == null ? runnable : new JbootDistributedRunnable(runnable, AnnotationUtil.get(enableDistributedRunnable.redisKey()), enableDistributedRunnable.expireSeconds());
            this.scheduleRunnableCache.put(runnableClass, executeRunnable);
            this.cron4jPlugin.addTask(value, executeRunnable, cron.daemon());
        }
    }

    public void removeSchedule(Class<? extends Runnable> removeClass) {
        ScheduledFuture<?> sf;
        Runnable runnable = this.scheduleRunnableCache.get(removeClass);
        if (runnable != null) {
            this.fixedScheduler.remove(runnable);
            this.scheduleRunnableCache.remove(removeClass);
        }
        if ((sf = this.scheduleFutureCache.remove(removeClass)) != null) {
            sf.cancel(true);
        }
    }

    public Map<Class<?>, Runnable> getScheduleRunnableCache() {
        return this.scheduleRunnableCache;
    }

    public JbootCron4jPlugin getCron4jPlugin() {
        return this.cron4jPlugin;
    }

    public ScheduledThreadPoolExecutor getFixedScheduler() {
        return this.fixedScheduler;
    }

    public JbooScheduleConfig getConfig() {
        return this.config;
    }

    public Map<Class<?>, ScheduledFuture<?>> getScheduleFutureCache() {
        return this.scheduleFutureCache;
    }
}

