/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.schedule;

import com.jfinal.kit.LogKit;
import com.jfinal.log.Log;
import io.jboot.Jboot;
import io.jboot.support.redis.JbootRedis;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.QuietlyUtil;
import io.jboot.utils.StrUtil;

public class JbootDistributedRunnable
implements Runnable {
    private static final Log LOG = Log.getLog(JbootDistributedRunnable.class);
    private JbootRedis redis;
    private int expire = 60000;
    private String key;
    private Runnable runnable;

    public JbootDistributedRunnable(Runnable runnable, String key, int expireSeconds) {
        this.runnable = runnable;
        this.key = StrUtil.isNotBlank(key) ? key : "jboot-distributed-key:" + ClassUtil.getUsefulClass(runnable.getClass()).getName();
        if (expireSeconds > 0) {
            this.expire = expireSeconds * 1000;
        }
        this.redis = Jboot.getRedis();
        if (this.redis == null) {
            LOG.warn("Redis is null, Can not use @EnableDistributedRunnable in your class: " + ClassUtil.getUsefulClass(runnable.getClass()).getName() + ", Please config redis info in jboot.properties");
        }
    }

    @Override
    public void run() {
        if (this.redis == null) {
            this.runnable.run();
            return;
        }
        Long setTimeMillis = System.currentTimeMillis();
        String setValue = setTimeMillis + ":" + StrUtil.uuid();
        boolean locked = false;
        for (int i = 0; i < 5; ++i) {
            String value;
            Long result = this.redis.setnx(this.key, setValue);
            if (result == null) {
                this.quietlySleep();
                continue;
            }
            if (result == 1L) {
                value = (String)this.redis.get(this.key);
                if (setValue.equals(value)) {
                    locked = true;
                    break;
                }
                this.quietlySleep();
                continue;
            }
            if (result != 0L) continue;
            value = null;
            try {
                value = (String)this.redis.get(this.key);
            }
            catch (Exception ex) {
                LogKit.logNothing((Throwable)ex);
            }
            if (value == null) {
                this.reset();
                this.quietlySleep();
                continue;
            }
            String[] split = value.split(":");
            if (split.length != 2) {
                this.reset();
                continue;
            }
            long savedTimeMillis = 0L;
            try {
                savedTimeMillis = Long.parseLong(split[0]);
            }
            catch (NumberFormatException ex) {
                LogKit.logNothing((Throwable)ex);
            }
            if (savedTimeMillis == 0L) {
                this.reset();
                continue;
            }
            if (System.currentTimeMillis() - savedTimeMillis > (long)this.expire) {
                this.reset();
                continue;
            }
            this.quietlySleep();
        }
        if (!locked) {
            return;
        }
        try {
            this.runnable.run();
        }
        catch (Throwable ex) {
            LOG.error(ex.toString(), ex);
            this.reset();
        }
    }

    private void reset() {
        try {
            this.redis.del((Object)this.key);
        }
        catch (Exception ex) {
            LogKit.logNothing((Throwable)ex);
        }
    }

    public void quietlySleep() {
        int millis = 2000;
        if (this.expire <= 2000) {
            millis = 100;
        } else if (this.expire <= 5000) {
            millis = 500;
        } else if (this.expire <= 300000) {
            millis = 1000;
        }
        QuietlyUtil.sleepQuietly(millis);
    }
}

