/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.rpc.motan;

import com.weibo.api.motan.config.AbstractConfig;
import com.weibo.api.motan.config.BasicRefererInterfaceConfig;
import com.weibo.api.motan.config.BasicServiceInterfaceConfig;
import com.weibo.api.motan.config.MethodConfig;
import com.weibo.api.motan.config.ProtocolConfig;
import com.weibo.api.motan.config.RefererConfig;
import com.weibo.api.motan.config.RegistryConfig;
import com.weibo.api.motan.config.ServiceConfig;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import io.jboot.components.rpc.JbootrpcReferenceConfig;
import io.jboot.components.rpc.JbootrpcServiceConfig;
import io.jboot.components.rpc.RPCUtil;
import io.jboot.utils.ConfigUtil;
import io.jboot.utils.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MotanUtil {
    private static Map<String, ProtocolConfig> protocolConfigMap = new ConcurrentHashMap<String, ProtocolConfig>();
    private static Map<String, RegistryConfig> registryConfigMap = new ConcurrentHashMap<String, RegistryConfig>();
    private static Map<String, BasicRefererInterfaceConfig> baseRefererConfigMap = new ConcurrentHashMap<String, BasicRefererInterfaceConfig>();
    private static Map<String, BasicServiceInterfaceConfig> baseServiceConfigMap = new ConcurrentHashMap<String, BasicServiceInterfaceConfig>();

    public static void initMotan() {
        Map<String, ProtocolConfig> protocolConfigs = MotanUtil.configs(ProtocolConfig.class, "jboot.rpc.motan.protocol");
        if (!protocolConfigs.isEmpty()) {
            protocolConfigMap.putAll(protocolConfigs);
        } else {
            protocolConfigMap.put("default", MotanFrameworkUtil.getDefaultProtocolConfig());
        }
        Map<String, RegistryConfig> registryConfigs = MotanUtil.configs(RegistryConfig.class, "jboot.rpc.motan.registry");
        if (!registryConfigs.isEmpty()) {
            registryConfigMap.putAll(registryConfigs);
        } else {
            registryConfigMap.put("default", MotanFrameworkUtil.getDefaultRegistryConfig());
        }
        Map<String, MethodConfig> methodConfigs = MotanUtil.configs(MethodConfig.class, "jboot.rpc.motan.method");
        Map<String, BasicServiceInterfaceConfig> serviceConfigs = MotanUtil.configs(BasicServiceInterfaceConfig.class, "jboot.rpc.motan.service");
        RPCUtil.setChildConfig(serviceConfigs, methodConfigs, "jboot.rpc.motan.service", "method");
        RPCUtil.setChildConfig(serviceConfigs, protocolConfigs, "jboot.rpc.motan.service", "protocol");
        RPCUtil.setChildConfig(serviceConfigs, registryConfigs, "jboot.rpc.motan.service", "registry");
        if (!serviceConfigs.isEmpty()) {
            baseServiceConfigMap.putAll(serviceConfigs);
        }
        Map<String, BasicRefererInterfaceConfig> refererConfigs = MotanUtil.configs(BasicRefererInterfaceConfig.class, "jboot.rpc.motan.referer");
        RPCUtil.setChildConfig(refererConfigs, methodConfigs, "jboot.rpc.motan.referer", "method");
        RPCUtil.setChildConfig(refererConfigs, protocolConfigs, "jboot.rpc.motan.referer", "protocol");
        RPCUtil.setChildConfig(refererConfigs, registryConfigs, "jboot.rpc.motan.referer", "registry");
        if (!refererConfigs.isEmpty()) {
            baseRefererConfigMap.putAll(refererConfigs);
        }
    }

    public static RefererConfig toRefererConfig(JbootrpcReferenceConfig jbootrpcReferenceConfig) {
        ProtocolConfig registryConfig;
        RefererConfig refererConfig = new RefererConfig();
        RPCUtil.copyDeclaredFields(jbootrpcReferenceConfig, refererConfig);
        if (jbootrpcReferenceConfig.getConsumer() != null) {
            refererConfig.setBasicReferer(baseRefererConfigMap.get(jbootrpcReferenceConfig.getConsumer()));
        } else {
            for (BasicRefererInterfaceConfig baseConfig : baseRefererConfigMap.values()) {
                if (baseConfig.isDefault() == null || !baseConfig.isDefault().booleanValue()) continue;
                refererConfig.setBasicReferer(baseConfig);
            }
        }
        if (StrUtil.isNotBlank(jbootrpcReferenceConfig.getProtocol())) {
            ArrayList<ProtocolConfig> protocolConfigs = new ArrayList<ProtocolConfig>();
            Set<String> protocolNames = StrUtil.splitToSetByComma(jbootrpcReferenceConfig.getProtocol());
            for (String protocalName : protocolNames) {
                registryConfig = protocolConfigMap.get(protocalName);
                if (registryConfig == null) continue;
                protocolConfigs.add(registryConfig);
            }
            if (!protocolConfigs.isEmpty()) {
                refererConfig.setProtocols(protocolConfigs);
            }
        } else {
            refererConfig.setProtocols(MotanUtil.toList(protocolConfigMap));
        }
        if (StrUtil.isNotBlank(jbootrpcReferenceConfig.getRegistry())) {
            ArrayList<ProtocolConfig> registryConfigs = new ArrayList<ProtocolConfig>();
            Set<String> registryNames = StrUtil.splitToSetByComma(jbootrpcReferenceConfig.getRegistry());
            for (String registryName : registryNames) {
                registryConfig = registryConfigMap.get(registryName);
                if (registryConfig == null) continue;
                registryConfigs.add(registryConfig);
            }
            if (!registryConfigs.isEmpty()) {
                refererConfig.setRegistries(registryConfigs);
            }
        } else {
            refererConfig.setRegistries(MotanUtil.toList(registryConfigMap));
        }
        return refererConfig;
    }

    public static ServiceConfig toServiceConfig(JbootrpcServiceConfig jbootrpcServiceConfig) {
        ProtocolConfig registryConfig;
        ServiceConfig serviceConfig = new ServiceConfig();
        RPCUtil.copyDeclaredFields(jbootrpcServiceConfig, serviceConfig);
        if (jbootrpcServiceConfig.getProvider() != null) {
            serviceConfig.setBasicService(baseServiceConfigMap.get(jbootrpcServiceConfig.getProvider()));
        } else {
            for (BasicServiceInterfaceConfig baseConfig : baseServiceConfigMap.values()) {
                if (baseConfig.isDefault() == null || !baseConfig.isDefault().booleanValue()) continue;
                serviceConfig.setBasicService(baseConfig);
            }
        }
        if (StrUtil.isNotBlank(jbootrpcServiceConfig.getProtocol())) {
            ArrayList<ProtocolConfig> protocolConfigs = new ArrayList<ProtocolConfig>();
            Set<String> protocolNames = StrUtil.splitToSetByComma(jbootrpcServiceConfig.getProtocol());
            for (String protocalName : protocolNames) {
                registryConfig = protocolConfigMap.get(protocalName);
                if (registryConfig == null) continue;
                protocolConfigs.add(registryConfig);
            }
            if (!protocolConfigs.isEmpty()) {
                serviceConfig.setProtocols(protocolConfigs);
            }
        } else {
            serviceConfig.setProtocols(MotanUtil.toList(protocolConfigMap));
        }
        if (StrUtil.isNotBlank(jbootrpcServiceConfig.getRegistry())) {
            ArrayList<ProtocolConfig> registryConfigs = new ArrayList<ProtocolConfig>();
            Set<String> registryNames = StrUtil.splitToSetByComma(jbootrpcServiceConfig.getRegistry());
            for (String registryName : registryNames) {
                registryConfig = registryConfigMap.get(registryName);
                if (registryConfig == null) continue;
                registryConfigs.add(registryConfig);
            }
            if (!registryConfigs.isEmpty()) {
                serviceConfig.setRegistries(registryConfigs);
            }
        } else {
            serviceConfig.setRegistries(MotanUtil.toList(registryConfigMap));
        }
        return serviceConfig;
    }

    public static BasicRefererInterfaceConfig getBaseReferer(String name) {
        return baseRefererConfigMap.get(name);
    }

    public static BasicServiceInterfaceConfig getBaseService(String name) {
        return baseServiceConfigMap.get(name);
    }

    private static <T> Map<String, T> configs(Class<T> clazz, String prefix) {
        Map<String, T> ret = ConfigUtil.getConfigModels(clazz, prefix);
        if (!(ret.size() <= 0 || clazz != BasicServiceInterfaceConfig.class && clazz != BasicRefererInterfaceConfig.class || RPCUtil.isDefaultConfigExist(clazz, ret))) {
            for (Map.Entry<String, T> entry : ret.entrySet()) {
                if (!"default".equals(entry.getKey())) continue;
                if (entry.getValue() instanceof BasicServiceInterfaceConfig) {
                    ((BasicServiceInterfaceConfig)entry.getValue()).setDefault(true);
                    continue;
                }
                if (!(entry.getValue() instanceof BasicRefererInterfaceConfig)) continue;
                ((BasicRefererInterfaceConfig)entry.getValue()).setDefault(true);
            }
        }
        return ret;
    }

    private static <T> List<T> toList(Map<String, T> map) {
        ArrayList<AbstractConfig> list = new ArrayList<AbstractConfig>(map.size());
        for (Map.Entry<String, T> entry : map.entrySet()) {
            AbstractConfig config = (AbstractConfig)entry.getValue();
            config.setId(entry.getKey());
            list.add(config);
        }
        return list;
    }
}

