/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.rpc.dubbo;

import io.jboot.Jboot;
import io.jboot.app.config.JbootConfigManager;
import io.jboot.components.rpc.JbootrpcReferenceConfig;
import io.jboot.components.rpc.JbootrpcServiceConfig;
import io.jboot.components.rpc.RPCUtil;
import io.jboot.utils.ConfigUtil;
import io.jboot.utils.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ArgumentConfig;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.SslConfig;
import org.apache.dubbo.config.bootstrap.DubboBootstrap;

class DubboUtil {
    private static Map<String, ProtocolConfig> protocolConfigMap = new ConcurrentHashMap<String, ProtocolConfig>();
    private static Map<String, RegistryConfig> registryConfigMap = new ConcurrentHashMap<String, RegistryConfig>();
    private static Map<String, ProviderConfig> providerConfigMap = new ConcurrentHashMap<String, ProviderConfig>();
    private static Map<String, ConsumerConfig> consumerConfigMap = new ConcurrentHashMap<String, ConsumerConfig>();

    DubboUtil() {
    }

    public static void stopDubbo() {
        DubboBootstrap.getInstance().stop();
    }

    public static void initDubbo() {
        Map<String, RegistryConfig> registryConfigs;
        Map<String, ProtocolConfig> protocolConfigs;
        Map<String, ConfigCenterConfig> configCenterConfigs;
        DubboBootstrap dubboBootstrap = DubboBootstrap.getInstance();
        ApplicationConfig applicationConfig = DubboUtil.config(ApplicationConfig.class, "jboot.rpc.dubbo.application");
        if (StrUtil.isBlank((String)applicationConfig.getName())) {
            applicationConfig.setName("jboot");
        }
        if (applicationConfig.getQosEnable() == null) {
            applicationConfig.setQosEnable(Boolean.valueOf(false));
        }
        dubboBootstrap.application(applicationConfig);
        SslConfig sslConfig = DubboUtil.config(SslConfig.class, "jboot.rpc.dubbo.ssl");
        dubboBootstrap.ssl(sslConfig);
        MonitorConfig monitorConfig = DubboUtil.config(MonitorConfig.class, "jboot.rpc.dubbo.monitor");
        dubboBootstrap.monitor(monitorConfig);
        MetricsConfig metricsConfig = DubboUtil.config(MetricsConfig.class, "jboot.rpc.dubbo.metrics");
        dubboBootstrap.metrics(metricsConfig);
        ModuleConfig moduleConfig = DubboUtil.config(ModuleConfig.class, "jboot.rpc.dubbo.module");
        dubboBootstrap.module(moduleConfig);
        Map<String, MetadataReportConfig> metadataReportConfigs = DubboUtil.configs(MetadataReportConfig.class, "jboot.rpc.dubbo.metadata-report");
        if (!metadataReportConfigs.isEmpty()) {
            dubboBootstrap.metadataReports(DubboUtil.toList(metadataReportConfigs));
        }
        if (!(configCenterConfigs = DubboUtil.configs(ConfigCenterConfig.class, "jboot.rpc.dubbo.config-center")).isEmpty()) {
            dubboBootstrap.configCenters(DubboUtil.toList(configCenterConfigs));
        }
        if (!(protocolConfigs = DubboUtil.configs(ProtocolConfig.class, "jboot.rpc.dubbo.protocol")).isEmpty()) {
            protocolConfigMap.putAll(protocolConfigs);
            dubboBootstrap.protocols(DubboUtil.toList(protocolConfigs));
        }
        if (!(registryConfigs = DubboUtil.configs(RegistryConfig.class, "jboot.rpc.dubbo.registry")).isEmpty()) {
            registryConfigMap.putAll(registryConfigs);
            dubboBootstrap.registries(DubboUtil.toList(registryConfigs));
        } else {
            RegistryConfig config = new RegistryConfig();
            config.setAddress("N/A");
            dubboBootstrap.registry(config);
        }
        Map<String, ArgumentConfig> argumentConfigs = DubboUtil.configs(ArgumentConfig.class, "jboot.rpc.dubbo.argument");
        Map<String, MethodConfig> methodConfigs = DubboUtil.configs(MethodConfig.class, "jboot.rpc.dubbo.method");
        for (MethodConfig methodConfig : methodConfigs.values()) {
            Object onthrow;
            Object oninvoke;
            Object onreturn = methodConfig.getOnreturn();
            if (onreturn instanceof String && ((String)onreturn).contains(".")) {
                String[] objectAndMethod = ((String)onreturn).split("\\.");
                methodConfig.setOnreturn(Jboot.getBean(objectAndMethod[0]));
                methodConfig.setOnreturnMethod(objectAndMethod[1]);
            }
            if ((oninvoke = methodConfig.getOninvoke()) instanceof String && ((String)oninvoke).contains(".")) {
                String[] objectAndMethod = ((String)oninvoke).split("\\.");
                methodConfig.setOninvoke(Jboot.getBean(objectAndMethod[0]));
                methodConfig.setOninvokeMethod(objectAndMethod[1]);
            }
            if (!((onthrow = methodConfig.getOnthrow()) instanceof String) || !((String)onthrow).contains(".")) continue;
            String[] objectAndMethod = ((String)onthrow).split("\\.");
            methodConfig.setOnthrow(Jboot.getBean(objectAndMethod[0]));
            methodConfig.setOnthrowMethod(objectAndMethod[1]);
        }
        RPCUtil.setChildConfig(methodConfigs, argumentConfigs, "jboot.rpc.dubbo.method", "argument");
        Map<String, ConsumerConfig> consumerConfigs = DubboUtil.configs(ConsumerConfig.class, "jboot.rpc.dubbo.consumer");
        RPCUtil.setChildConfig(consumerConfigs, methodConfigs, "jboot.rpc.dubbo.consumer", "method");
        RPCUtil.setChildConfig(consumerConfigs, registryConfigs, "jboot.rpc.dubbo.consumer", "registry");
        if (!consumerConfigs.isEmpty()) {
            consumerConfigMap.putAll(consumerConfigs);
            dubboBootstrap.consumers(DubboUtil.toList(consumerConfigs));
        }
        Map<String, ProviderConfig> providerConfigs = DubboUtil.configs(ProviderConfig.class, "jboot.rpc.dubbo.provider");
        RPCUtil.setChildConfig(providerConfigs, methodConfigs, "jboot.rpc.dubbo.provider", "method");
        RPCUtil.setChildConfig(providerConfigs, protocolConfigs, "jboot.rpc.dubbo.provider", "protocol");
        RPCUtil.setChildConfig(providerConfigs, registryConfigs, "jboot.rpc.dubbo.provider", "registry");
        if (!providerConfigs.isEmpty()) {
            providerConfigMap.putAll(providerConfigs);
            dubboBootstrap.providers(DubboUtil.toList(providerConfigs));
        }
    }

    public static ReferenceConfig toReferenceConfig(JbootrpcReferenceConfig jbootReferenceConfig) {
        ReferenceConfig referenceConfig = new ReferenceConfig();
        RPCUtil.copyDeclaredFields(jbootReferenceConfig, referenceConfig);
        if (jbootReferenceConfig.getConsumer() != null) {
            referenceConfig.setConsumer(consumerConfigMap.get(jbootReferenceConfig.getConsumer()));
        } else {
            for (ConsumerConfig consumerConfig : consumerConfigMap.values()) {
                if (consumerConfig.isDefault() == null || !consumerConfig.isDefault().booleanValue()) continue;
                referenceConfig.setConsumer(consumerConfig);
            }
        }
        if (StrUtil.isNotBlank(jbootReferenceConfig.getRegistry())) {
            referenceConfig.setRegistryIds(jbootReferenceConfig.getRegistry());
        } else {
            for (RegistryConfig registryConfig : registryConfigMap.values()) {
                if (registryConfig.isDefault() == null || !registryConfig.isDefault().booleanValue()) continue;
                referenceConfig.setRegistry(registryConfig);
            }
        }
        return referenceConfig;
    }

    public static ServiceConfig toServiceConfig(JbootrpcServiceConfig jbootServiceConfig) {
        ServiceConfig serviceConfig = new ServiceConfig();
        RPCUtil.copyDeclaredFields(jbootServiceConfig, serviceConfig);
        if (StrUtil.isNotBlank(jbootServiceConfig.getProvider())) {
            serviceConfig.setProviderIds(jbootServiceConfig.getProvider());
        } else {
            for (ProviderConfig providerConfig : providerConfigMap.values()) {
                if (providerConfig.isDefault() == null || !providerConfig.isDefault().booleanValue()) continue;
                serviceConfig.setProvider(providerConfig);
            }
        }
        if (StrUtil.isNotBlank(jbootServiceConfig.getProtocol())) {
            serviceConfig.setProtocolIds(jbootServiceConfig.getProtocol());
        } else {
            for (ProtocolConfig protocolConfig : protocolConfigMap.values()) {
                if (protocolConfig.isDefault() == null || !protocolConfig.isDefault().booleanValue()) continue;
                serviceConfig.setProtocol(protocolConfig);
            }
        }
        if (StrUtil.isNotBlank(jbootServiceConfig.getRegistry())) {
            serviceConfig.setRegistryIds(jbootServiceConfig.getRegistry());
        } else {
            for (RegistryConfig registryConfig : registryConfigMap.values()) {
                if (registryConfig.isDefault() == null || !registryConfig.isDefault().booleanValue()) continue;
                serviceConfig.setRegistry(registryConfig);
            }
        }
        return serviceConfig;
    }

    public static ConsumerConfig getConsumer(String name) {
        return consumerConfigMap.get(name);
    }

    public static ProviderConfig getProvider(String name) {
        return providerConfigMap.get(name);
    }

    private static <T> T config(Class<T> clazz, String prefix) {
        return JbootConfigManager.me().get(clazz, prefix, null);
    }

    private static <T> Map<String, T> configs(Class<T> clazz, String prefix) {
        Map<String, T> ret = ConfigUtil.getConfigModels(clazz, prefix);
        if (ret.size() > 0 && !RPCUtil.isDefaultConfigExist(clazz, ret)) {
            for (Map.Entry<String, T> entry : ret.entrySet()) {
                if (!"default".equals(entry.getKey())) continue;
                if (entry.getValue() instanceof ProviderConfig) {
                    ((ProviderConfig)entry.getValue()).setDefault(Boolean.valueOf(true));
                    continue;
                }
                if (entry.getValue() instanceof ConsumerConfig) {
                    ((ConsumerConfig)entry.getValue()).setDefault(Boolean.valueOf(true));
                    continue;
                }
                if (entry.getValue() instanceof ProtocolConfig) {
                    ((ProtocolConfig)entry.getValue()).setDefault(Boolean.valueOf(true));
                    continue;
                }
                if (!(entry.getValue() instanceof RegistryConfig)) continue;
                ((RegistryConfig)entry.getValue()).setDefault(Boolean.valueOf(true));
            }
        }
        return ret;
    }

    private static <T> List<T> toList(Map<String, T> map) {
        ArrayList<AbstractConfig> list = new ArrayList<AbstractConfig>(map.size());
        for (Map.Entry<String, T> entry : map.entrySet()) {
            AbstractConfig config = (AbstractConfig)entry.getValue();
            config.setId(entry.getKey());
            list.add(config);
        }
        return list;
    }
}

