/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.rpc;

import io.jboot.components.rpc.JbootrpcReferenceConfig;
import io.jboot.components.rpc.RPCUtil;
import io.jboot.components.rpc.annotation.RPCInject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReferenceConfigCache {
    private static Map<Integer, JbootrpcReferenceConfig> configs = new ConcurrentHashMap<Integer, JbootrpcReferenceConfig>();

    public static JbootrpcReferenceConfig getReferenceConfig(RPCInject rpcInject) {
        int identityHashCode = System.identityHashCode(rpcInject);
        JbootrpcReferenceConfig referenceConfig = configs.get(identityHashCode);
        if (referenceConfig == null) {
            JbootrpcReferenceConfig config = new JbootrpcReferenceConfig();
            RPCUtil.appendAnnotation(RPCInject.class, rpcInject, config);
            configs.putIfAbsent(identityHashCode, config);
            referenceConfig = configs.get(identityHashCode);
        }
        return referenceConfig;
    }
}

