/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.rpc;

import io.jboot.Jboot;
import io.jboot.utils.AnnotationUtil;
import io.jboot.utils.CollectionUtil;
import io.jboot.utils.StrUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RPCUtil {
    public static void appendAnnotation(Class<?> annotationClass, Object annotation, Object appendTo) {
        Method[] methods;
        for (Method method : methods = annotationClass.getMethods()) {
            if (method.getDeclaringClass() == Object.class || method.getReturnType() == Void.TYPE || "toString".equals(method.getName()) || "hashCode".equals(method.getName()) || "annotationType".equals(method.getName()) || method.getParameterTypes().length != 0 || !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) continue;
            try {
                String property = method.getName();
                if ("interfaceClass".equals(property) || "interfaceName".equals(property)) {
                    property = "interface";
                }
                String setter = "set" + property.substring(0, 1).toUpperCase() + property.substring(1);
                Map<String, String> value = method.invoke(annotation, new Object[0]);
                if (value == null || ((Object)value).equals(method.getDefaultValue())) continue;
                Method setterMethod = null;
                if ("filter".equals(property) || "listener".equals(property) || "registry".equals(property)) {
                    value = StrUtil.join((String[])value, ",");
                    setterMethod = RPCUtil.getMethod(appendTo.getClass(), setter, String.class);
                } else if ("parameters".equals(property)) {
                    value = CollectionUtil.string2Map((String)((Object)value));
                    setterMethod = RPCUtil.getMethod(appendTo.getClass(), setter, Map.class);
                } else {
                    setterMethod = RPCUtil.getMethod(appendTo.getClass(), setter, method.getReturnType());
                }
                if (value instanceof String) {
                    value = AnnotationUtil.get((String)((Object)value));
                }
                if (setterMethod == null) continue;
                setterMethod.invoke(appendTo, value);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void copyDeclaredFields(Object copyFrom, Object copyTo) {
        Field[] fields;
        for (Field field : fields = copyFrom.getClass().getDeclaredFields()) {
            try {
                String setterName = "set" + StrUtil.firstCharToUpperCase((String)field.getName());
                Method method = RPCUtil.getMethod(copyTo.getClass(), setterName, field.getType());
                if (method == null) continue;
                field.setAccessible(true);
                Object value = field.get(copyFrom);
                if (value == null || value.equals("0") || value.equals("")) continue;
                method.invoke(copyTo, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?> type) {
        try {
            return clazz.getMethod(methodName, RPCUtil.getBoxedClass(type));
        }
        catch (NoSuchMethodException e) {
            try {
                return clazz.getMethod(methodName, type);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
    }

    public static void copyNotNullFields(Object copyFrom, Object copyTo, boolean override) {
        Method[] fromObjGetters;
        if (copyFrom == null || copyTo == null) {
            return;
        }
        for (Method getter : fromObjGetters = copyFrom.getClass().getMethods()) {
            String getterMethodName = getter.getName();
            if (getterMethodName.length() <= 3 || !getterMethodName.startsWith("get") || !Modifier.isPublic(getter.getModifiers()) || getter.getParameterCount() != 0) continue;
            try {
                Object newData;
                Class<?> returnType = getter.getReturnType();
                if (override) {
                    Object newData2 = getter.invoke(copyFrom, new Object[0]);
                    if (newData2 == null) continue;
                    Method setter = copyTo.getClass().getMethod("set" + getterMethodName.substring(3), returnType);
                    setter.invoke(copyTo, newData2);
                    continue;
                }
                Object oldData = copyTo.getClass().getMethod(getterMethodName, new Class[0]).invoke(copyTo, new Object[0]);
                if (oldData != null || (newData = getter.invoke(copyFrom, new Object[0])) == null) continue;
                Method setter = copyTo.getClass().getMethod("set" + getterMethodName.substring(3), returnType);
                setter.invoke(copyTo, newData);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static <T> boolean isDefaultConfigExist(Class<T> clazz, Map<String, T> ret) {
        try {
            Field field = clazz.getField("isDefault");
            field.setAccessible(true);
            for (T obj : ret.values()) {
                Boolean fieldValue = (Boolean)field.get(obj);
                if (fieldValue == null || !fieldValue.booleanValue()) continue;
                return true;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return false;
    }

    public static <T, F> void setChildConfig(Map<String, T> appendTo, Map<String, F> dataSource, String prefix, String arrName) {
        if (appendTo != null && !appendTo.isEmpty()) {
            for (Map.Entry<String, T> entry : appendTo.entrySet()) {
                String configKey = "default".equals(entry.getKey()) ? prefix + "." + arrName : prefix + "." + entry.getKey() + "." + arrName;
                String configValue = Jboot.configValue(configKey, "default");
                ArrayList<F> argCfgList = new ArrayList<F>();
                Set<String> arguments = StrUtil.splitToSetByComma(configValue);
                for (String arg : arguments) {
                    F fillObj = dataSource.get(arg);
                    if (fillObj == null) continue;
                    argCfgList.add(fillObj);
                }
                if (argCfgList.isEmpty()) continue;
                try {
                    String setterMethodName = arrName.equals("registry") ? "setRegistries" : "set" + StrUtil.firstCharToUpperCase((String)arrName) + "s";
                    Method method = entry.getValue().getClass().getMethod(setterMethodName, List.class);
                    method.invoke(entry.getValue(), argCfgList);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static Class<?> getBoxedClass(Class<?> c) {
        if (c == Integer.TYPE) {
            c = Integer.class;
        } else if (c == Boolean.TYPE) {
            c = Boolean.class;
        } else if (c == Long.TYPE) {
            c = Long.class;
        } else if (c == Float.TYPE) {
            c = Float.class;
        } else if (c == Double.TYPE) {
            c = Double.class;
        } else if (c == Character.TYPE) {
            c = Character.class;
        } else if (c == Byte.TYPE) {
            c = Byte.class;
        } else if (c == Short.TYPE) {
            c = Short.class;
        }
        return c;
    }
}

