/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.rpc;

import io.jboot.Jboot;
import io.jboot.components.rpc.Jbootrpc;
import io.jboot.components.rpc.JbootrpcConfig;
import io.jboot.components.rpc.JbootrpcReferenceConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class JbootrpcBase
implements Jbootrpc {
    protected static final Map<String, Object> objectCache = new ConcurrentHashMap<String, Object>();
    protected static JbootrpcConfig rpcConfig = Jboot.config(JbootrpcConfig.class);
    private boolean started = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T serviceObtain(Class<T> interfaceClass, JbootrpcReferenceConfig config) {
        String key = this.buildKey(interfaceClass, config);
        Object object = objectCache.get(key);
        if (object == null) {
            JbootrpcBase jbootrpcBase = this;
            synchronized (jbootrpcBase) {
                object = objectCache.get(key);
                if (object == null) {
                    this.invokeOnStartIfNecessary();
                    object = this.onServiceCreate(interfaceClass, config);
                    if (object != null) {
                        objectCache.put(key, object);
                    }
                }
            }
        }
        return (T)object;
    }

    protected String buildKey(Class<?> interfaceClass, JbootrpcReferenceConfig config) {
        return interfaceClass.getName() + "@" + System.identityHashCode(config);
    }

    protected synchronized void invokeOnStartIfNecessary() {
        if (!this.started) {
            this.onStart();
            this.setStarted(true);
        }
    }

    public abstract <T> T onServiceCreate(Class<T> var1, JbootrpcReferenceConfig var2);

    @Override
    public void onStart() {
    }

    @Override
    public void onStop() {
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }
}

