/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.mq;

import io.jboot.Jboot;
import io.jboot.components.mq.Jbootmq;
import io.jboot.components.mq.JbootmqConfig;
import io.jboot.components.mq.aliyunmq.JbootAliyunmqImpl;
import io.jboot.components.mq.local.JbootLocalmqImpl;
import io.jboot.components.mq.qpidmq.JbootQpidmqImpl;
import io.jboot.components.mq.rabbitmq.JbootRabbitmqImpl;
import io.jboot.components.mq.redismq.JbootRedismqImpl;
import io.jboot.components.mq.rocketmq.JbootRocketmqImpl;
import io.jboot.core.spi.JbootSpiLoader;
import io.jboot.exception.JbootIllegalConfigException;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.ConfigUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JbootmqManager {
    private static JbootmqManager manager;
    private Map<String, Jbootmq> jbootmqMap = new ConcurrentHashMap<String, Jbootmq>();

    public static JbootmqManager me() {
        if (manager == null) {
            manager = ClassUtil.singleton(JbootmqManager.class);
        }
        return manager;
    }

    public Jbootmq getJbootmq() {
        return this.getJbootmq("default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Jbootmq getJbootmq(String name) {
        Jbootmq mq = this.jbootmqMap.get(name);
        if (mq == null) {
            JbootmqManager jbootmqManager = this;
            synchronized (jbootmqManager) {
                mq = this.jbootmqMap.get(name);
                if (mq == null) {
                    Map<String, JbootmqConfig> configModels = ConfigUtil.getConfigModels(JbootmqConfig.class);
                    JbootmqConfig.TYPES.forEach(configModels::remove);
                    configModels.putIfAbsent("default", Jboot.config(JbootmqConfig.class));
                    if (!configModels.containsKey(name)) {
                        throw new JbootIllegalConfigException("Please config \"jboot.mq." + name + ".type\" in your jboot.properties.");
                    }
                    mq = this.getJbootmq(configModels.get(name));
                    if (mq != null) {
                        this.jbootmqMap.put(name, mq);
                    }
                }
            }
        }
        return mq;
    }

    public Jbootmq getJbootmq(JbootmqConfig config) {
        return this.buildJbootmq(config);
    }

    private Jbootmq buildJbootmq(JbootmqConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        if (!config.isConfigOk()) {
            return null;
        }
        switch (config.getType()) {
            case "redis": {
                return new JbootRedismqImpl(config);
            }
            case "aliyunmq": {
                return new JbootAliyunmqImpl(config);
            }
            case "rabbitmq": {
                return new JbootRabbitmqImpl(config);
            }
            case "rocketmq": {
                return new JbootRocketmqImpl(config);
            }
            case "qpid": {
                return new JbootQpidmqImpl(config);
            }
            case "activemq": {
                throw new RuntimeException("not finished!!!!");
            }
            case "local": {
                return new JbootLocalmqImpl(config);
            }
        }
        return JbootSpiLoader.load(Jbootmq.class, config.getType(), config);
    }
}

