/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.mq;

import com.jfinal.kit.LogKit;
import com.jfinal.log.Log;
import io.jboot.Jboot;
import io.jboot.components.mq.Jbootmq;
import io.jboot.components.mq.JbootmqConfig;
import io.jboot.components.mq.JbootmqMessageListener;
import io.jboot.components.mq.MessageContext;
import io.jboot.components.serializer.JbootSerializer;
import io.jboot.exception.JbootException;
import io.jboot.utils.NamedThreadFactory;
import io.jboot.utils.StrUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class JbootmqBase
implements Jbootmq {
    private static final Log LOG = Log.getLog(JbootmqBase.class);
    private List<JbootmqMessageListener> globalListeners = new CopyOnWriteArrayList<JbootmqMessageListener>();
    private Map<String, List<JbootmqMessageListener>> channelListeners = new ConcurrentHashMap<String, List<JbootmqMessageListener>>();
    protected Set<String> channels = new HashSet<String>();
    protected Set<String> syncRecevieMessageChannels = new HashSet<String>();
    protected JbootSerializer serializer;
    protected final JbootmqConfig config;
    private final ExecutorService threadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new NamedThreadFactory("jbootmq"));
    protected boolean isStarted = false;

    public JbootmqBase(JbootmqConfig config) {
        this.config = config;
        String channelString = config.getChannel();
        if (StrUtil.isBlank((String)channelString)) {
            return;
        }
        this.channels.addAll(StrUtil.splitToSet(channelString, ","));
        if (StrUtil.isNotBlank(config.getSyncRecevieMessageChannel())) {
            this.syncRecevieMessageChannels.addAll(StrUtil.splitToSet(config.getSyncRecevieMessageChannel(), ","));
        }
    }

    @Override
    public void addMessageListener(JbootmqMessageListener listener) {
        this.globalListeners.add(listener);
    }

    @Override
    public void addMessageListener(JbootmqMessageListener listener, String forChannel) {
        String[] forChannels;
        for (String channel : forChannels = forChannel.split(",")) {
            if (!StrUtil.isNotBlank(channel)) continue;
            this.addChannelListener(channel.trim(), listener);
        }
    }

    private synchronized void addChannelListener(String channel, JbootmqMessageListener listener) {
        List<JbootmqMessageListener> listeners = this.channelListeners.get(channel);
        if (listeners == null) {
            listeners = new CopyOnWriteArrayList<JbootmqMessageListener>();
            this.channelListeners.put(channel, listeners);
        }
        listeners.add(listener);
    }

    @Override
    public void removeListener(JbootmqMessageListener listener) {
        this.globalListeners.remove(listener);
        for (List<JbootmqMessageListener> listeners : this.channelListeners.values()) {
            listeners.remove(listener);
        }
    }

    @Override
    public void removeAllListeners() {
        this.globalListeners.clear();
        this.channelListeners.forEach((s, list) -> list.clear());
        this.channelListeners.clear();
    }

    @Override
    public Collection<JbootmqMessageListener> getGlobalListeners() {
        return this.globalListeners;
    }

    @Override
    public Collection<JbootmqMessageListener> getListenersByChannel(String channel) {
        return this.channelListeners.get(channel);
    }

    public void notifyListeners(String channel, Object message, MessageContext context) {
        boolean globalResult = this.notifyListeners(channel, message, context, this.globalListeners);
        boolean channelResult = this.notifyListeners(channel, message, context, (Collection<JbootmqMessageListener>)this.channelListeners.get(channel));
        if (!globalResult && !channelResult) {
            LOG.warn("Jboot has recevied mq message, But it has no listener to process. channel:" + channel + "  message:" + message);
        }
    }

    protected boolean notifyListeners(String channel, Object message, MessageContext context, Collection<JbootmqMessageListener> listeners) {
        if (listeners == null || listeners.size() == 0) {
            return false;
        }
        if (this.syncRecevieMessageChannels.contains(channel)) {
            for (JbootmqMessageListener listener : listeners) {
                try {
                    listener.onMessage(channel, message, context);
                }
                catch (Throwable ex) {
                    LOG.warn("listener[" + listener.getClass().getName() + "] execute mq message is error. channel:" + channel + "  message:" + message);
                }
            }
        } else {
            for (JbootmqMessageListener listener : listeners) {
                this.threadPool.execute(() -> listener.onMessage(channel, message, context));
            }
        }
        return true;
    }

    public JbootSerializer getSerializer() {
        if (this.serializer == null) {
            this.serializer = StrUtil.isNotBlank(this.config.getSerializer()) ? Jboot.getSerializer(this.config.getSerializer()) : Jboot.getSerializer();
        }
        return this.serializer;
    }

    @Override
    public boolean startListening() {
        if (this.isStarted) {
            throw new JbootException("Jboot MQ has started.");
        }
        if (this.channels == null || this.channels.isEmpty()) {
            throw new JbootException("Jboot MQ's channels is null or empty, Please config channels.");
        }
        try {
            this.isStarted = true;
            this.onStartListening();
        }
        catch (Exception ex) {
            LogKit.error((String)"Jboot MQ start fail!", (Throwable)ex);
            this.isStarted = false;
            return false;
        }
        return true;
    }

    @Override
    public boolean stopListening() {
        if (!this.isStarted) {
            throw new JbootException("Jboot MQ has stoped.");
        }
        try {
            this.isStarted = false;
            this.onStopListening();
        }
        catch (Exception ex) {
            LogKit.error((String)"Jboot MQ stop fail!", (Throwable)ex);
            this.isStarted = true;
            return false;
        }
        return true;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    protected abstract void onStartListening();

    protected abstract void onStopListening();

    @Override
    public JbootmqConfig getConfig() {
        return this.config;
    }
}

