/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.limiter.redis;

import io.jboot.exception.JbootIllegalConfigException;
import io.jboot.support.redis.JbootRedis;
import io.jboot.support.redis.JbootRedisManager;

public class RedisRateLimitUtil {
    private static final String RATE_LIMIT_SCRIPT = "local c\nc = redis.call('get',KEYS[1])\nif c and tonumber(c) > tonumber(ARGV[1]) then\nreturn tonumber(c);\nend\nc = redis.call('incr',KEYS[1])\nif tonumber(c) == 1 then\nredis.call('expire',KEYS[1],ARGV[2])\nend\nreturn c;";
    private static JbootRedis redis;

    public static boolean tryAcquire(String resource, int rate) {
        return RedisRateLimitUtil.tryAcquire(resource, rate, 1);
    }

    public static boolean tryAcquire(String resource, int rate, int periodSeconds) {
        if (redis == null && (redis = JbootRedisManager.me().getRedis()) == null) {
            throw new JbootIllegalConfigException("Redis config not well, can not use LimitScope.CLUSTER in @EnableLimit() ");
        }
        Long count = (Long)redis.eval(RATE_LIMIT_SCRIPT, 1, resource, String.valueOf(rate), String.valueOf(periodSeconds));
        return count <= (long)rate;
    }
}

