/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.limiter.interceptor;

import io.jboot.aop.InterceptorBuilder;
import io.jboot.aop.Interceptors;
import io.jboot.aop.annotation.AutoLoad;
import io.jboot.components.limiter.LimiterManager;
import io.jboot.components.limiter.annotation.EnableLimit;
import io.jboot.components.limiter.interceptor.LimiterGlobalInterceptor;
import io.jboot.components.limiter.interceptor.LimiterInterceptor;
import io.jboot.core.weight.Weight;
import java.lang.reflect.Method;

@AutoLoad
@Weight(value=-1)
public class LimiterInterceptorBuilder
implements InterceptorBuilder {
    private LimiterManager manager = LimiterManager.me();

    @Override
    public void build(Class<?> targetClass, Method method, Interceptors interceptors) {
        if (this.manager.isEnable() && !this.manager.getLimitConfigBeans().isEmpty()) {
            interceptors.add(LimiterGlobalInterceptor.class);
            return;
        }
        if (InterceptorBuilder.Util.hasAnnotation(method, EnableLimit.class)) {
            interceptors.add(LimiterInterceptor.class);
        }
    }
}

