/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.limiter.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import io.jboot.components.limiter.LimitScope;
import io.jboot.components.limiter.LimiterManager;
import io.jboot.components.limiter.annotation.EnableLimit;
import io.jboot.components.limiter.interceptor.BaseLimiterInterceptor;
import io.jboot.utils.AnnotationUtil;
import io.jboot.utils.RequestUtil;
import io.jboot.utils.StrUtil;

public class LimiterInterceptor
extends BaseLimiterInterceptor
implements Interceptor {
    public void intercept(Invocation inv) {
        if (inv.isActionInvocation() && LimiterManager.me().isInIpWhitelist(RequestUtil.getIpAddress(inv.getController().getRequest()))) {
            inv.invoke();
        } else {
            String packageOrTarget = this.getPackageOrTarget(inv);
            EnableLimit enableLimit = inv.getMethod().getAnnotation(EnableLimit.class);
            String resource = StrUtil.obtainDefault(enableLimit.resource(), packageOrTarget);
            this.doInterceptByLimitInfo(enableLimit, resource, inv);
        }
    }

    private void doInterceptByLimitInfo(EnableLimit enableLimit, String resource, Invocation inv) {
        String type;
        switch (type = AnnotationUtil.get(enableLimit.type())) {
            case "cc": {
                if (LimitScope.CLUSTER == enableLimit.scope()) {
                    throw new IllegalArgumentException("Concurrency limit for cluster not implement!");
                }
                this.doInterceptForConcurrency(enableLimit.rate(), resource, enableLimit.fallback(), inv);
                break;
            }
            case "ipcc": {
                if (LimitScope.CLUSTER == enableLimit.scope()) {
                    throw new IllegalArgumentException("Ip limit for cluster not implement!");
                }
                String resKey1 = RequestUtil.getIpAddress(inv.getController().getRequest()) + ":" + resource;
                this.doInterceptForConcurrency(enableLimit.rate(), resKey1, enableLimit.fallback(), inv);
                break;
            }
            case "tb": {
                if (LimitScope.CLUSTER == enableLimit.scope()) {
                    this.doInterceptForTokenBucketWithCluster(enableLimit.rate(), resource, enableLimit.fallback(), inv);
                    break;
                }
                this.doInterceptForTokenBucket(enableLimit.rate(), resource, enableLimit.fallback(), inv);
                break;
            }
            case "iptb": {
                String resKey2 = RequestUtil.getIpAddress(inv.getController().getRequest()) + ":" + resource;
                if (LimitScope.CLUSTER == enableLimit.scope()) {
                    this.doInterceptForTokenBucketWithCluster(enableLimit.rate(), resKey2, enableLimit.fallback(), inv);
                    break;
                }
                this.doInterceptForTokenBucket(enableLimit.rate(), resKey2, enableLimit.fallback(), inv);
            }
        }
    }
}

