/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.limiter.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import io.jboot.components.limiter.LimiterManager;
import io.jboot.components.limiter.interceptor.BaseLimiterInterceptor;
import io.jboot.utils.RequestUtil;

public class LimiterGlobalInterceptor
extends BaseLimiterInterceptor
implements Interceptor {
    public void intercept(Invocation inv) {
        LimiterManager manager = LimiterManager.me();
        if (inv.isActionInvocation() && manager.isInIpWhitelist(RequestUtil.getIpAddress(inv.getController().getRequest()))) {
            inv.invoke();
        } else {
            String packageOrTarget = this.getPackageOrTarget(inv);
            LimiterManager.LimitConfigBean configBean = manager.matchConfig(packageOrTarget);
            if (configBean != null) {
                this.doInterceptByTypeAndRate(configBean, packageOrTarget, inv);
            } else {
                inv.invoke();
            }
        }
    }

    private void doInterceptByTypeAndRate(LimiterManager.LimitConfigBean limitConfigBean, String resource, Invocation inv) {
        switch (limitConfigBean.getType()) {
            case "cc": {
                this.doInterceptForConcurrency(limitConfigBean.getRate(), resource, null, inv);
                break;
            }
            case "ipcc": {
                String resKey1 = RequestUtil.getIpAddress(inv.getController().getRequest()) + ":" + resource;
                this.doInterceptForConcurrency(limitConfigBean.getRate(), resKey1, null, inv);
                break;
            }
            case "tb": {
                this.doInterceptForTokenBucket(limitConfigBean.getRate(), resource, null, inv);
                break;
            }
            case "iptb": {
                String resKey2 = RequestUtil.getIpAddress(inv.getController().getRequest()) + ":" + resource;
                this.doInterceptForTokenBucket(limitConfigBean.getRate(), resKey2, null, inv);
            }
        }
    }
}

