/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.limiter.interceptor;

import com.google.common.util.concurrent.RateLimiter;
import com.jfinal.aop.Invocation;
import io.jboot.components.limiter.LimiterManager;
import io.jboot.components.limiter.redis.RedisRateLimitUtil;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.StrUtil;
import java.util.concurrent.Semaphore;
import javax.servlet.http.HttpServletRequest;

public abstract class BaseLimiterInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInterceptForConcurrency(int rate, String resource, String fallback, Invocation inv) {
        Semaphore semaphore = LimiterManager.me().getOrCreateSemaphore(resource, rate);
        boolean acquire = false;
        try {
            acquire = semaphore.tryAcquire();
            if (acquire) {
                inv.invoke();
            } else {
                this.doExecFallback(resource, fallback, inv);
            }
        }
        finally {
            if (acquire) {
                semaphore.release();
            }
        }
    }

    protected void doInterceptForTokenBucket(int rate, String resource, String fallback, Invocation inv) {
        RateLimiter limiter = LimiterManager.me().getOrCreateRateLimiter(resource, rate);
        if (limiter.tryAcquire()) {
            inv.invoke();
        } else {
            this.doExecFallback(resource, fallback, inv);
        }
    }

    protected void doInterceptForTokenBucketWithCluster(int rate, String resource, String fallback, Invocation inv) {
        if (RedisRateLimitUtil.tryAcquire(resource, rate)) {
            inv.invoke();
        } else {
            this.doExecFallback(resource, fallback, inv);
        }
    }

    protected void doExecFallback(String resource, String fallback, Invocation inv) {
        LimiterManager.me().processFallback(resource, fallback, inv);
    }

    protected String getPackageOrTarget(Invocation inv) {
        return inv.isActionInvocation() ? this.buildUrl(inv) : ClassUtil.buildMethodString(inv.getMethod());
    }

    protected String buildUrl(Invocation inv) {
        HttpServletRequest request = inv.getController().getRequest();
        String uri = request.getRequestURI();
        String query = request.getQueryString();
        return StrUtil.isBlank((String)query) ? uri : uri + "?" + query;
    }
}

