/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.limiter;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.util.concurrent.RateLimiter;
import com.jfinal.aop.Invocation;
import io.jboot.Jboot;
import io.jboot.components.limiter.LimitConfig;
import io.jboot.components.limiter.LimitFallbackProcesser;
import io.jboot.components.limiter.LimitFallbackProcesserDefault;
import io.jboot.components.limiter.LimitType;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.StrUtil;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class LimiterManager {
    private HashSet<LimitConfigBean> limitConfigBeans = new HashSet();
    private HashSet<String> ipWhitelist = new HashSet();
    private LimitConfig limitConfig = Jboot.config(LimitConfig.class);
    private Cache<String, Semaphore> semaphoreCache = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).expireAfterWrite(10L, TimeUnit.MINUTES).build();
    private Cache<String, RateLimiter> rateLimiterCache = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).expireAfterWrite(10L, TimeUnit.MINUTES).build();
    private LimitFallbackProcesser fallbackProcesser;
    private static LimiterManager me = new LimiterManager();

    private LimiterManager() {
    }

    public static LimiterManager me() {
        return me;
    }

    public void init() {
        this.doInitFallbackProcesser();
        this.doParseConfig();
        Set<String> ips = StrUtil.splitToSetByComma(this.limitConfig.getIpWhitelist());
        if (ips != null) {
            this.ipWhitelist.addAll(ips);
        }
    }

    private void doInitFallbackProcesser() {
        LimitConfig config = Jboot.config(LimitConfig.class);
        this.fallbackProcesser = StrUtil.isBlank((String)config.getFallbackProcesser()) ? new LimitFallbackProcesserDefault() : (LimitFallbackProcesser)Objects.requireNonNull(ClassUtil.newInstance(config.getFallbackProcesser()), "can not newInstance class for " + config.getFallbackProcesser());
    }

    private void doParseConfig() {
        String[] rules;
        LimitConfig config = Jboot.config(LimitConfig.class);
        if (!this.isEnable()) {
            return;
        }
        String rule = config.getRule();
        if (StrUtil.isBlank((String)rule)) {
            return;
        }
        for (String r : rules = rule.split(",")) {
            String rate;
            String type;
            String packageOrTarget;
            String[] confs = r.split(":");
            if (confs == null || confs.length != 3 || !this.ensureLegal(packageOrTarget = confs[0], type = confs[1], (rate = confs[2]).trim())) continue;
            packageOrTarget = packageOrTarget.replace(".", "\\.").replace("(", "\\(").replace(")", "\\)").replace("*", ".*");
            this.limitConfigBeans.add(new LimitConfigBean(packageOrTarget.trim(), type.trim(), Integer.valueOf(rate.trim())));
        }
    }

    public LimitConfigBean matchConfig(String packageOrTarget) {
        if (!this.isEnable() || this.limitConfigBeans.isEmpty()) {
            return null;
        }
        for (LimitConfigBean value : this.limitConfigBeans) {
            if (!value.isMatched(packageOrTarget)) continue;
            return value;
        }
        return null;
    }

    public boolean isInIpWhitelist(String ip) {
        return !this.ipWhitelist.isEmpty() && this.ipWhitelist.contains(ip);
    }

    public RateLimiter getOrCreateRateLimiter(String resKey, int rate) {
        return (RateLimiter)this.rateLimiterCache.get((Object)resKey, s -> RateLimiter.create((double)rate));
    }

    public Semaphore getOrCreateSemaphore(String resKey, int rate) {
        return (Semaphore)this.semaphoreCache.get((Object)resKey, s -> new Semaphore(rate));
    }

    public HashSet<LimitConfigBean> getLimitConfigBeans() {
        return this.limitConfigBeans;
    }

    private boolean ensureLegal(String packageOrTarget, String type, String rate) {
        if (StrUtil.isBlank((String)packageOrTarget)) {
            return false;
        }
        if (!LimitType.types.contains(type)) {
            return false;
        }
        return StrUtil.isNumeric(rate);
    }

    public boolean isEnable() {
        return this.limitConfig.isEnable();
    }

    public void processFallback(String resource, String fallback, Invocation inv) {
        this.fallbackProcesser.process(resource, fallback, inv);
    }

    public static class LimitConfigBean {
        private String packageOrTarget;
        private String type;
        private int rate;
        private Pattern pattern;

        public LimitConfigBean(String packageOrTarget, String type, int rate) {
            this.packageOrTarget = packageOrTarget;
            this.type = type;
            this.rate = rate;
            this.pattern = Pattern.compile(packageOrTarget);
        }

        public String getPackageOrTarget() {
            return this.packageOrTarget;
        }

        public void setPackageOrTarget(String packageOrTarget) {
            this.packageOrTarget = packageOrTarget;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public int getRate() {
            return this.rate;
        }

        public void setRate(int rate) {
            this.rate = rate;
        }

        public boolean isMatched(String packageOrTarget) {
            return this.pattern.matcher(packageOrTarget).matches();
        }
    }
}

