/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.http;

import com.jfinal.log.Log;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public class JbootHttpResponse
implements Closeable {
    private static final Log LOG = Log.getLog(JbootHttpResponse.class);
    private String content;
    private OutputStream contentStream;
    private File file;
    private Throwable error;
    private Map<String, List<String>> headers;
    private int responseCode;
    private String contentType;

    public JbootHttpResponse() {
        this.contentStream = new ByteArrayOutputStream();
    }

    public JbootHttpResponse(File file) {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            LOG.error("Can not mkdirs for: " + file.getParentFile());
        }
        if (file.exists() && !file.delete()) {
            LOG.error("Can not delete file: " + file);
        }
        try {
            this.file = file;
            this.contentStream = new FileOutputStream(file);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getContent() {
        if (this.content != null) {
            return this.content;
        }
        if (this.contentStream != null && this.contentStream instanceof ByteArrayOutputStream) {
            return new String(((ByteArrayOutputStream)this.contentStream).toByteArray());
        }
        return null;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void copyStream(InputStream inputStream) {
        try {
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inputStream.read(buffer)) > 0) {
                this.contentStream.write(buffer, 0, len);
            }
        }
        catch (Throwable throwable) {
            LOG.error(throwable.toString(), throwable);
            this.setError(throwable);
        }
    }

    @Override
    public void close() {
        if (this.contentStream != null) {
            try {
                this.contentStream.flush();
                this.contentStream.close();
            }
            catch (IOException e) {
                LOG.error(e.toString(), (Throwable)e);
            }
        }
    }

    public boolean isNotError() {
        return !this.isError();
    }

    public boolean isError() {
        return this.error != null;
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String toString() {
        return "JbootHttpResponse{\nfile=" + this.file + "\nheaders=" + this.headers + "\nresponseCode=" + this.responseCode + "\ncontentType=" + this.contentType + "\ncontent=" + this.getContent() + "\n}";
    }
}

